/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function.impl.fullgift;

import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.AbstractConditionRuleFunction;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.util.CommonConstant;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="conditionNoNo")
public class ConditionNoNo
extends AbstractConditionRuleFunction<ConditionRuleParam, ConditionRuleResponse> {
    public static final String FUNC_BODY = "conditionNoNo";
    @Resource
    private LadderResolverHelper ladderResolverHelper;

    @Override
    public ConditionRuleResponse apply(ConditionRuleParam conditionRuleParam) {
        AbstractConditionRuleLadderResolver ladderResolver = this.ladderResolverHelper.getResolverByFuncBody(FUNC_BODY);
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = conditionRuleParam.getProductOrderBuy();
        BigDecimal productBuyNo = BigDecimal.ZERO;
        String ladderNoUnit = ladderResolver.unitAsProductCurrentY(conditionRuleParam.getLadder());
        if (null != productOrderBuy) {
            for (RuleExecuteParam.ProductOrderBuy v : productOrderBuy) {
                productBuyNo = productBuyNo.add(v.getProductBuyNo());
            }
        }
        Object response = this.divideAndRemainder(productBuyNo, ladderResolver.valueAsProductCurrentY(conditionRuleParam.getLadder()));
        ((ConditionRuleResponse)response).setResultDataType(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode());
        String unitType = ladderResolver.unitAsProductCurrentN(conditionRuleParam.getLadder());
        ((ConditionRuleResponse)response).setGiftValue(ladderResolver.valueAsProductCurrentN(conditionRuleParam.getLadder()));
        ((ConditionRuleResponse)response).setResultDataUnitType(unitType);
        return response;
    }

    @Override
    public String getConditionType() {
        return CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode();
    }
}

