/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans.productfilters;

import com.biz.crm.promotion.service.npromotion.PromotionProductService;
import com.biz.crm.promotion.service.npromotion.beans.AbstractProductFilter;
import com.biz.crm.promotion.service.npromotion.vo.PromotionHitReq;
import com.biz.crm.promotion.service.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"productFilterExtendImpl"})
public class ProductFilterImpl
extends AbstractProductFilter {
    @Resource
    private PromotionProductService promotionProductService;

    @Override
    public Map<String, List<String>> apply(PromotionHitReq param) {
        if (param == null || CollectionUtil.listEmpty(param.getSaleProductVos())) {
            return Maps.newHashMap();
        }
        List<PromotionSaleProductVo> saleProductVos = param.getSaleProductVos();
        saleProductVos = saleProductVos.stream().filter(product -> StringUtils.isNotEmpty((String)product.getProductCode())).collect(Collectors.toList());
        HashMap result = Maps.newHashMap();
        saleProductVos.forEach(product -> {
            List<String> promotionCodes = this.promotionProductService.findPromotionCodesByProductCode(product.getProductCode());
            result.put(product.getProductCode(), promotionCodes);
        });
        return result;
    }
}

