/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.eunm.dms.ControlTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractConditionComputer
implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {
    public static final String NUMBER = "number";
    public static final String AMOUNT = "amount";
    public static final String PRICE = "price";
    public static final String RATIO = "ratio";

    public ConditionResultBo conditionApply(ConditionParamBo param) {
        ConditionResultBo conditionResultBo = new ConditionResultBo();
        if (param == null) {
            return conditionResultBo;
        }
        LadderParseBo ladderParseBo = this.parseLadder(param.getLadder());
        String sourceType = ladderParseBo.getSourceValueType();
        BigDecimal quantity = BigDecimal.ZERO;
        if (AMOUNT.equals(sourceType)) {
            quantity = param.getAmount();
        } else if (NUMBER.equals(sourceType)) {
            quantity = param.getCount();
        }
        this.buildDivide(conditionResultBo, quantity, ladderParseBo);
        return conditionResultBo;
    }

    public LadderParseBo parseLadder(PromotionRuleEditVo.ControlRow ladder) {
        List controls = ladder.getControls();
        LadderParseBo ladderParseBo = this.parseLadderByType(controls, ControlTypeDynamicEnum.COUNT_COUNT.getCode());
        return ladderParseBo;
    }

    protected LadderParseBo parseLadderByType(List<PromotionRuleEditVo.KeyValParamControl> controls, String type2) {
        if (CollectionUtil.listEmpty(controls)) {
            return null;
        }
        return PromotionUtil.parseLadderByType(controls, type2);
    }

    protected void buildDivide(ConditionResultBo conditionResultBo, BigDecimal quantity, LadderParseBo ladderParseBo) {
        if (conditionResultBo == null || quantity == null || ladderParseBo == null) {
            return;
        }
        if (ladderParseBo.getSourceValue() == null || BigDecimal.ZERO.compareTo(ladderParseBo.getSourceValue()) >= 0) {
            conditionResultBo.setMultiple(BigDecimal.ONE);
            conditionResultBo.setRemainder(BigDecimal.ZERO);
            conditionResultBo.setValue(ladderParseBo.getTargetValue() == null ? BigDecimal.ZERO : ladderParseBo.getTargetValue());
            conditionResultBo.setValueType(ladderParseBo.getTargetValueType());
            conditionResultBo.setUnitType(ladderParseBo.getTargetUnitType());
            return;
        }
        BigDecimal[] remainders = quantity.divideAndRemainder(ladderParseBo.getSourceValue());
        conditionResultBo.setMultiple(remainders[0]);
        conditionResultBo.setRemainder(remainders[1]);
        if (conditionResultBo.getMultiple().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        conditionResultBo.setValue(ladderParseBo.getTargetValue() == null ? BigDecimal.ZERO : ladderParseBo.getTargetValue());
        conditionResultBo.setValueType(ladderParseBo.getTargetValueType());
        conditionResultBo.setUnitType(ladderParseBo.getTargetUnitType());
    }

    @Override
    public CalculateRuleResponse apply(CalculateRuleParam p) {
        return new CalculateRuleResponse();
    }

    @Override
    public CalculateRuleResponse test(TestRuleParam testRuleParam) {
        return new CalculateRuleResponse();
    }
}

