/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.validators;

import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TimeUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"promotionValidatorExtend"})
public class PromotionValidator {
    public void validateCreate(PromotionEditVo editVo) {
        ValidateUtils.validate((Object)editVo, (String)"\u65b0\u589e\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((boolean)StringUtils.isEmpty((String)editVo.getId()), (String)"\u65b0\u589e\u4fc3\u9500\u653f\u7b56\u65f6\uff0cid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        ValidateUtils.validate((Object)StringUtils.isNotEmpty((String)editVo.getTemplateCode()), (String)"\u65b0\u589e\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u5f15\u64ce\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)StringUtils.isNotEmpty((String)editVo.getTemplateId()), (String)"\u65b0\u589e\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u5f15\u64ceid\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)editVo.getPromotionType(), (String)"\u65b0\u589e\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((Objects.equals(editVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode()) || ((List)editVo.getProductMap().get("currentProducts")).size() <= 1 ? 1 : 0) != 0, (String)"\u53ea\u6709\u4fc3\u9500\u7c7b\u578b\u4e3a\u4e70\u8d60\u65f6\uff0c\u672c\u54c1\u624d\u80fd\u7ec4\u5408\uff0c\u5373\uff1a\u53ea\u6709\u4e70\u8d60\u53ef\u4ee5\u9009\u62e9\u591a\u4e2a\u672c\u54c1", (Object[])new Object[0]);
        ValidateUtils.notEmpty((Collection)((Collection)editVo.getRuleMap().get(RuleTypeDynamicEnum.CALCULATE.getObjectName())), (String)"\u8ba1\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
    }

    public void validateUpdate(PromotionEditVo editVo) {
        ValidateUtils.validate((Object)editVo, (String)"\u7f16\u8f91\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)editVo.getId(), (String)"\u7f16\u8f91\u4fc3\u9500\u653f\u7b56\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)StringUtils.isNotEmpty((String)editVo.getTemplateCode()), (String)"\u7f16\u8f91\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u5f15\u64ce\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)StringUtils.isNotEmpty((String)editVo.getTemplateId()), (String)"\u7f16\u8f91\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u5f15\u64ceid\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)editVo.getPromotionType(), (String)"\u7f16\u8f91\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((Objects.equals(editVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode()) || ((List)editVo.getProductMap().get("currentProducts")).size() <= 1 ? 1 : 0) != 0, (String)"\u53ea\u6709\u4fc3\u9500\u7c7b\u578b\u4e3a\u4e70\u8d60\u65f6\uff0c\u672c\u54c1\u624d\u80fd\u7ec4\u5408\uff0c\u5373\uff1a\u53ea\u6709\u4e70\u8d60\u53ef\u4ee5\u9009\u62e9\u591a\u4e2a\u672c\u54c1", (Object[])new Object[0]);
        ValidateUtils.isTrue((!"009".equals(editVo.getEnableStatus()) || !TimeUtil.bigThan(new Date(), DateUtils.parseDate((String)editVo.getBeginTime(), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"})) ? 1 : 0) != 0, (String)"\u542f\u7528\u72b6\u6001\u5e76\u4e14\u751f\u6548\u671f\u5185\u7684\u653f\u7b56\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        ValidateUtils.notEmpty((Collection)((Collection)editVo.getRuleMap().get(RuleTypeDynamicEnum.CALCULATE.getObjectName())), (String)"\u8ba1\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
    }
}

