/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.filter.impl;

import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.PromotionPolicyUtils;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.JsonPropertyUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="promotionPolicySingleProductFilter")
public class PromotionPolicySingleProductFilter
extends AbstractFilter<PromotionPolicyInfoDataVo, LoadConfigInfoContext> {
    @Override
    public boolean filter(PromotionPolicyInfoDataVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        Map<String, Map<String, PromotionPolicyProductEntity>> currentProductMap = context.getCurrentProductY();
        Map<String, PromotionPolicyProductEntity> currentProduct = currentProductMap.get(promotionPolicyInfoVo.getId());
        this.addHitDetail(promotionPolicyInfoVo, "currentProduct", String.valueOf(JsonPropertyUtil.toJsonString(currentProduct)));
        Map<String, Map<String, BigDecimal>> productsOrderBuyMap = context.getProductsOrderBuyMap();
        this.addHitDetail(promotionPolicyInfoVo, "productsOrderBuyMap", String.valueOf(JsonPropertyUtil.toJsonString(productsOrderBuyMap)));
        for (Map.Entry<String, PromotionPolicyProductEntity> entry : currentProduct.entrySet()) {
            PromotionPolicyProductEntity productEntity = entry.getValue();
            String qtyType = productEntity.getProductOrderQtyType();
            BigDecimal qty = productEntity.getProductOrderQty();
            if (!StringUtils.isNotBlank((CharSequence)qtyType) || null == qty) continue;
            String currentProductCode = entry.getKey();
            if (!productsOrderBuyMap.containsKey(currentProductCode)) {
                return false;
            }
            BigDecimal orderQty = PromotionPolicyUtils.getOrderQty(qtyType, currentProductCode, context);
            if (null != orderQty && qty.compareTo(orderQty) <= 0) continue;
            return false;
        }
        return true;
    }
}

