/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans.filters.commonfilters;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.dms.PromotionEnum;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.mapper.DmsPromotionPolicyOrderDetailMapper;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractCommonFilter;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component(value="FirstOrderFilterImpl50")
@ConditionalOnMissingBean(name={"firstOrderFilterExtendImpl50"})
public class FirstOrderFilterImpl
extends AbstractCommonFilter {
    @Resource
    private DmsPromotionPolicyOrderDetailMapper dmsPromotionPolicyOrderDetailMapper;

    @Override
    public List<PromotionEditVo> filter(List<PromotionEditVo> promotions, PromotionQueryReq queryReq) {
        if (CollectionUtil.listEmpty(promotions) || queryReq == null || StringUtils.isEmpty((String)queryReq.getAccountCode())) {
            return Lists.newArrayList();
        }
        List ids = promotions.stream().map(UuidVo::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(DmsPromotionPolicyOrderDetailEntity::getPromotionPolicyId, ids);
        wrapper.eq(DmsPromotionPolicyOrderDetailEntity::getCustomerCode, (Object)queryReq.getAccountCode());
        wrapper.ne(DmsPromotionPolicyOrderDetailEntity::getPolicyOrderDetailStatus, (Object)PromotionEnum.POLICY_ORDER_DETAIL.rollback.getVal());
        List entities = this.dmsPromotionPolicyOrderDetailMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return promotions;
        }
        List usedIds = entities.stream().map(DmsPromotionPolicyOrderDetailEntity::getPromotionPolicyId).collect(Collectors.toList());
        List usedPromotions = promotions.stream().filter(p -> Objects.equals(p.getFirstOrder(), CommonConstant.GLOBAL.YesOrNo.Y.getItemCode()) && usedIds.contains(p.getId())).collect(Collectors.toList());
        promotions.removeAll(usedPromotions);
        return promotions;
    }
}

