/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ba1\u7406\u7aef-\u8ba2\u5355", tags={"\u7ba1\u7406\u7aef-\u8ba2\u5355"})
@RestController
@RequestMapping(value={"/m/order"})
public class OrdermController {
    @Resource
    private OrderService orderService;

    @CrmLog
    @ApiOperation(value="\u7b97\u4ef7")
    @PostMapping(value={"cal"})
    public Result<OrderVo> cal(@RequestBody OrderVo orderVo) {
        OrderVo reVo = this.orderService.cal(orderVo, false);
        return Result.ok((Object)reVo);
    }

    @CrmLog
    @ApiOperation(value="\u7b97\u4ef7(\u8d27\u8865\u5355)")
    @PostMapping(value={"cal/rebate"})
    public Result<OrderVo> calForRebate(@RequestBody OrderVo orderVo) {
        OrderVo reVo = this.orderService.calForRebate(orderVo);
        return Result.ok((Object)reVo);
    }

    @CrmLog
    @ApiOperation(value="\u7b97\u4ef7(\u514d\u8d39\u5355)")
    @PostMapping(value={"cal/free"})
    public Result<OrderVo> calForFree(@RequestBody OrderVo orderVo) {
        OrderVo reVo = this.orderService.calForFree(orderVo);
        return Result.ok((Object)reVo);
    }

    @CrmLog
    @ApiOperation(value="\u6682\u5b58")
    @PostMapping(value={"/temporary/add"})
    public Result temporaryAdd(@RequestBody OrderVo orderVo) {
        this.orderService.temporaryAdd(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u7f16\u8f91\u8ba2\u5355")
    @PostMapping(value={"/edit"})
    public Result edit(@RequestBody OrderVo orderVo) {
        this.orderService.edit(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u4fdd\u5b58\u8ba2\u5355")
    @PostMapping(value={"/add"})
    public Result add(@RequestBody OrderVo orderVo) {
        this.orderService.add(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u4fdd\u5b58\u8ba2\u5355(\u8d27\u8865\u5355)")
    @PostMapping(value={"/add/rebate"})
    public Result addForRebate(@RequestBody OrderVo orderVo) {
        this.orderService.addForRebate(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u4fdd\u5b58\u8ba2\u5355(\u514d\u8d39\u5355)")
    @PostMapping(value={"/add/free"})
    public Result addForFree(@RequestBody OrderVo orderVo) {
        this.orderService.addForFree(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355\uff08\u9000\u5355\uff09")
    @PostMapping(value={"cancelByIds"})
    public Result cancelByIds(@RequestBody ArrayList<String> ids) {
        this.orderService.cancel(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"findDetailsById/{id}"})
    public Result<OrderVo> findDetailsById(@PathVariable(name="id") String id) {
        OrderVo result = this.orderService.findDetailsById(id);
        return Result.ok((Object)result);
    }

    @CrmLog
    @ApiOperation(value="\u901a\u8fc7\u6761\u4ef6\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"listByConditions"})
    public Result listByConditions(@RequestBody OrderVo orderVo) {
        return Result.ok(this.orderService.listByConditions(orderVo));
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5(\u4e0d\u8be2\u4ef7)")
    @GetMapping(value={"findSimpleDetailsById/{id}"})
    public Result<OrderVo> findSimpleDetailsById(@PathVariable(name="id") String id) {
        OrderVo result = this.orderService.findSimpleDetailsById(id);
        return Result.ok((Object)result);
    }
}

