/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.mdm.customer.MdmCustomerROrgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyForOrderProductReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyForOrderReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleVo;
import com.biz.crm.nebular.dms.promotion.param.QueryProductPolicyParamVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerROrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.entity.resp.PromotionPolicyPageResp;
import com.biz.crm.promotion.mapper.PromotionPolicyMapper;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.promotion.service.PromotionPolicyRuleService;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.AbstractProductFilter;
import com.biz.crm.promotion.service.component.validator.PromotionPolicyEditValidator;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.util.dms.PromotionPolicyUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyServiceExpandImpl"})
@Service(value="promotionPolicyService")
public class PromotionPolicyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyMapper, PromotionPolicyEntity>
implements PromotionPolicyService {
    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;
    @Resource
    private PromotionPolicyRuleService promotionPolicyRuleService;
    @Resource
    private PromotionRuleService promotionRuleService;
    @Resource
    private PromotionPolicyScopeService promotionPolicyScopeService;
    @Resource
    private PromotionPolicyProductService promotionPolicyProductService;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private MdmCustomerROrgFeign mdmCustomerROrgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource(name="defaultRuleExecutor")
    private RuleExecutor defaultRuleExecutor;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private PromotionPolicyTemplateService promotionPolicyTemplateService;
    @Resource
    private List<AbstractFilter> abstractFilters;
    @Resource
    private List<AbstractProductFilter> abstractProductFilters;
    @Resource
    private List<PromotionPolicyEditValidator> promotionPolicyEditValidators;

    @Override
    public void addOrUpdate(PromotionPolicyEditReqVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getId())) {
            vo.setPromotionPolicyCode(CodeUtil.createOneCode((String)"dms_promotion_code"));
        }
        this.checkParams(vo);
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            PromotionPolicyEntity temp = (PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionPolicyEntity.class));
            this.promotionPolicyMapper.insert((Object)temp);
            this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode").toString(), vo.getId(), null, (Object)vo);
            vo.setId(temp.getId());
        } else {
            PromotionPolicyEntity oldEntity = (PromotionPolicyEntity)((Object)this.promotionPolicyMapper.selectById((Serializable)((Object)vo.getId())));
            if (null == oldEntity) {
                throw new BusinessException("\u653f\u7b56\u6570\u636e\u4e0d\u5b58\u5728,ID=[" + vo.getId() + "]");
            }
            vo.setPromotionPolicyCode(oldEntity.getPromotionPolicyCode());
            PromotionPolicyVo oldobj = (PromotionPolicyVo)CrmBeanUtil.copy((Object)((Object)oldEntity), PromotionPolicyVo.class);
            this.doUpdate(oldEntity, vo);
            PromotionPolicyVo newEntity = this.findById(vo.getId());
            PromotionPolicyVo newobj = (PromotionPolicyVo)CrmBeanUtil.copy((Object)newEntity, PromotionPolicyVo.class);
            this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), vo.getId(), null, (Object)oldobj, (Object)newobj);
        }
        this.promotionPolicyRuleService.refreshRule(vo);
        this.promotionPolicyScopeService.refreshScope(vo);
        this.promotionPolicyProductService.refreshProduct(vo);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), Lists.newArrayList((Object[])new String[]{vo.getId()}));
        PromotionUtil.deleteCaches(Lists.newArrayList((Object[])new String[]{vo.getPromotionPolicyCode()}));
    }

    private void checkParams(PromotionPolicyEditReqVo vo) {
        if (CollectionUtils.isEmpty(this.promotionPolicyEditValidators)) {
            return;
        }
        for (PromotionPolicyEditValidator promotionPolicyEditValidator : this.promotionPolicyEditValidators) {
            promotionPolicyEditValidator.validate(vo);
        }
    }

    @Override
    public List<String> countBeginAndEndAffectedCustoms(String date, List<String> promotionIds) {
        if (StringUtils.isBlank((CharSequence)date)) {
            date = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        }
        String onDate = LocalDate.parse(date).minusDays(1L).format(CrmDateUtils.yyyyMMdd);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.between((Object)"begin_time", (Object)date, (Object)(date + " " + "23:59:59"))).or()).between((Object)"end_time", (Object)onDate, (Object)(onDate + " " + "23:59:59"));
        Set<String> entitieIds = this.promotionPolicyMapper.selectList((Wrapper)wrapper).stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        if (CollectionUtil.listNotEmpty(promotionIds)) {
            entitieIds = entitieIds.stream().filter(id -> promotionIds.contains(id)).collect(Collectors.toSet());
        }
        if (promotionIds != null) {
            return Lists.newArrayList();
        }
        List<String> custCodes = this.promotionPolicyScopeService.countCustCodesByPromotionPolicyId(entitieIds);
        if (!CollectionUtils.isEmpty(custCodes)) {
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(custCodes));
            rocketMQMessageBody.setTag("CUS_AVAILBLELIST_REFRSH_PROMOTION");
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        return custCodes;
    }

    @Override
    public List<PromotionPolicyInfoDataVo> loadPromotionPolicyInfoByCustAndProduct(String custCode, String productCode) {
        if (StringUtils.isBlank((CharSequence)custCode) || StringUtils.isBlank((CharSequence)productCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u548c\u5546\u54c1\u7f16\u7801");
        }
        QueryProductPolicyParamVo productPolicyParamVo = new QueryProductPolicyParamVo();
        productPolicyParamVo.setCustCode(custCode);
        productPolicyParamVo.setProductCode(productCode);
        return this.loadPromotionPolicyInfos(productPolicyParamVo);
    }

    private List<PromotionPolicyInfoDataVo> loadPromotionPolicyInfos(QueryProductPolicyParamVo productPolicyParamVo) {
        String custCode = productPolicyParamVo.getCustCode();
        String productCode = productPolicyParamVo.getProductCode();
        Set<String> orgCodes = this.buildOrgCodes(custCode, productPolicyParamVo.getOrgCode());
        Set<String> terminalOrgCode = this.buildOrgCodesByTerminal(productPolicyParamVo.getTerminalCode(), productPolicyParamVo.getOrgCode());
        Set<String> promotionPolicyIdAsProduct = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCode(productCode);
        Set<String> promotionPolicyIdAsScope = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCodes);
        Set<String> promotionPolicyIdAsScopeTerminal = this.promotionPolicyScopeService.selectPromotionPolicyIdByTerminal(productPolicyParamVo.getTerminalCode(), terminalOrgCode);
        promotionPolicyIdAsScope.addAll(promotionPolicyIdAsScopeTerminal);
        List<String> merged = this.merge(promotionPolicyIdAsProduct, promotionPolicyIdAsScope);
        if (CollectionUtils.isEmpty(merged)) {
            return Lists.newArrayList();
        }
        return this.selectActivities((PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)productPolicyParamVo, PromotionPolicyEntity.class)), merged);
    }

    private Set<String> buildOrgCodesByTerminal(String terminalCode, String orgCode) {
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            return this.loadParentOrgCodes(Sets.newHashSet((Object[])new String[]{orgCode}));
        }
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return Sets.newHashSet();
        }
        MdmTerminalVo param = new MdmTerminalVo();
        param.setTerminalCodeList((List)Lists.newArrayList((Object[])new String[]{terminalCode}));
        List result = (List)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.detailBatch(param), (boolean)true);
        if (CollectionUtil.listEmpty((List)result)) {
            return Sets.newHashSet();
        }
        return result.stream().collect(Collectors.groupingBy(MdmOrgRespVo::getOrgCode)).keySet();
    }

    private List<PromotionPolicyInfoDataVo> selectActivities(PromotionPolicyEntity entity, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PromotionPolicyEntity.class).in(BaseIdEntity::getId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode());
        ArrayList chanel = Lists.newArrayList((Object[])new String[]{"ALL"});
        ArrayList saleCompanyCode = Lists.newArrayList((Object[])new String[]{"ALL"});
        if (null != entity) {
            if (StringUtils.isNotBlank((CharSequence)entity.getChanel())) {
                chanel.add(entity.getChanel());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getSaleCompanyCode())) {
                saleCompanyCode.add(entity.getSaleCompanyCode());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt1())) {
                wrapper.eq(CrmExtEntity::getExt1, (Object)entity.getExt1());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt2())) {
                wrapper.eq(CrmExtEntity::getExt2, (Object)entity.getExt2());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt3())) {
                wrapper.eq(CrmExtEntity::getExt3, (Object)entity.getExt3());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt4())) {
                wrapper.eq(CrmExtEntity::getExt4, (Object)entity.getExt4());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExt5())) {
                wrapper.eq(CrmExtEntity::getExt5, (Object)entity.getExt5());
            }
        }
        wrapper.in(PromotionPolicyEntity::getChanel, (Collection)chanel);
        wrapper.in(PromotionPolicyEntity::getSaleCompanyCode, (Collection)saleCompanyCode);
        ((LambdaQueryWrapper)wrapper.le(PromotionPolicyEntity::getBeginTime, (Object)(now + " " + "00:00:00"))).ge(PromotionPolicyEntity::getEndTime, (Object)(now + " " + "23:59:59"));
        List dataVos = CrmBeanUtil.copyList((List)this.promotionPolicyMapper.selectList((Wrapper)wrapper), PromotionPolicyInfoDataVo.class);
        String hitKey = wrapper.getCustomSqlSegment();
        String hitValue = JsonPropertyUtil.toJsonString((Object)wrapper.getParamNameValuePairs());
        this.addHitDetail(dataVos, hitKey, hitValue);
        return dataVos;
    }

    private void addHitDetail(List<PromotionPolicyInfoDataVo> dataVos, String hitKey, String hitValue) {
        if (null == dataVos) {
            return;
        }
        PromotionPolicyInfoDataVo.HitDetail hitDetail = new PromotionPolicyInfoDataVo.HitDetail(hitKey, hitValue);
        dataVos.forEach(v -> v.addHitDetail(hitDetail));
    }

    private Set<String> buildOrgCodes(String custCode, String orgCode) {
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            return this.loadParentOrgCodes(Sets.newHashSet((Object[])new String[]{orgCode}));
        }
        if (StringUtils.isBlank((CharSequence)custCode)) {
            return Sets.newHashSet();
        }
        Result result = this.mdmCustomerROrgFeign.findOrgCodeListByCustomerCode(new MdmCustomerROrgReqVo().setCustomerCode(custCode));
        List orgCodes = (List)ApiResultUtil.objResult((Result)result);
        if (null == orgCodes) {
            return Sets.newHashSet();
        }
        return this.loadParentOrgCodes(Sets.newHashSet((Iterable)orgCodes));
    }

    private Set<String> loadParentOrgCodes(Set<String> orgCodes) {
        List parentOrgCodes = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findAllParentOrgCodeExcludeSelf((List)Lists.newArrayList(orgCodes)));
        orgCodes.addAll(parentOrgCodes);
        return orgCodes;
    }

    private List<String> merge(Set<String> promotionPolicyIds, Set<String> promotionPolicyIdAsScope) {
        return promotionPolicyIds.stream().filter(v -> promotionPolicyIdAsScope.contains(v)).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoByCustAndProducts(String custCode, List<String> productCodes) {
        if (StringUtils.isBlank((CharSequence)custCode) || CollectionUtils.isEmpty(productCodes)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u548c\u5546\u54c1\u7f16\u7801");
        }
        productCodes = productCodes.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.toList());
        Set<String> orgCodes = this.buildOrgCodes(custCode, null);
        Set<String> promotionPolicyIdAsScope = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCodes);
        HashSet distinctProductCodes = Sets.newHashSet(productCodes);
        productCodes = Lists.newArrayList((Iterable)distinctProductCodes);
        List partitionList = Lists.partition((List)productCodes, (int)999);
        Map<String, List<PromotionPolicyInfoVo>> results = this.partitionListProccess(partitionList, promotionPolicyIdAsScope);
        for (String productCode : distinctProductCodes) {
            if (results.containsKey(productCode)) continue;
            results.put(productCode, Lists.newArrayList());
        }
        return results;
    }

    @Override
    public Map<String, Boolean> custProductsHasPromotionPolicy(String custCode, List<String> productCodes) {
        Map<String, List<PromotionPolicyInfoVo>> temp = this.loadPromotionPolicyInfoByCustAndProducts(custCode, productCodes);
        HashMap data = Maps.newHashMap();
        temp.forEach((s, promotionPolicyInfoVos) -> data.put(s, !CollectionUtils.isEmpty((Collection)promotionPolicyInfoVos)));
        return data;
    }

    private Map<String, List<PromotionPolicyInfoVo>> partitionListProccess(List<List<String>> partitionList, Set<String> promotionPolicyIdAsScope) {
        HashMap results = Maps.newHashMap();
        for (List<String> list : partitionList) {
            List<PromotionPolicyProductEntity> promotionPolicyIdAsProduct = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCodes(list);
            Map productCodeMapPromotionPolicyIds = promotionPolicyIdAsProduct.stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getProductCode, Collectors.mapping(PromotionPolicyProductEntity::getPromotionPolicyId, Collectors.toSet())));
            HashMap custProductPromotionPolicyId = Maps.newHashMap();
            HashSet mergedPromotionPolicyId = Sets.newHashSet();
            for (Map.Entry entry : productCodeMapPromotionPolicyIds.entrySet()) {
                String productCode = entry.getKey();
                Set<String> promotionPolicyIds = entry.getValue();
                List<String> temp = this.merge(promotionPolicyIds, promotionPolicyIdAsScope);
                custProductPromotionPolicyId.put(productCode, temp);
                mergedPromotionPolicyId.addAll(temp);
            }
            results.putAll(this.loadPromotionPolicyInfoVo(mergedPromotionPolicyId, custProductPromotionPolicyId));
        }
        return results;
    }

    private Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoVo(Set<String> mergedPromotionPolicyId, Map<String, List<String>> custProductPromotionPolicyId) {
        Map<Object, Object> infoVoMap = CollectionUtils.isEmpty(mergedPromotionPolicyId) ? Maps.newHashMap() : this.selectActivities(null, Lists.newArrayList(mergedPromotionPolicyId)).stream().collect(Collectors.toMap(UuidVo::getId, v -> v, (r, r2) -> r2));
        HashMap custProductPromotionPolicyInfoVo = Maps.newHashMap();
        for (Map.Entry<String, List<String>> entry : custProductPromotionPolicyId.entrySet()) {
            String productCode = entry.getKey();
            List<String> promotionPolicyIds = entry.getValue();
            ArrayList infoVos = Lists.newArrayList();
            promotionPolicyIds.forEach(v -> {
                if (infoVoMap.containsKey(v)) {
                    infoVos.add(infoVoMap.get(v));
                }
            });
            custProductPromotionPolicyInfoVo.put(productCode, infoVos);
        }
        return custProductPromotionPolicyInfoVo;
    }

    @Override
    public PromotionPolicyEditVo loadPolicyEditVo(String id, String templateId) {
        PromotionPolicyEditVo templateEditVo;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)this.promotionPolicyMapper.selectById((Serializable)((Object)id)));
            AssertUtils.isNotNull((Object)((Object)entity), (String)"\u672a\u52a0\u8f7d\u5230\u653f\u7b56\u6570\u636e");
            templateEditVo = (PromotionPolicyEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyEditVo.class);
        } else {
            AssertUtils.isNotEmpty((String)templateId, (String)"\u8bf7\u9009\u62e9\u4fc3\u9500\u653f\u7b56\u6a21\u677f");
            templateEditVo = new PromotionPolicyEditVo();
            templateEditVo.setTemplateId(templateId);
        }
        this.promotionPolicyProductService.loadListForEditPromotionPolicy(templateEditVo);
        this.promotionPolicyScopeService.loadListForEditPromotionPolicy(templateEditVo);
        this.promotionPolicyRuleService.loadListForEditPromotionPolicy(templateEditVo);
        Map map = DictUtil.getDictValueMapsByCodes((String)"promotion_policy_status");
        templateEditVo.setPromotionPolicyStatus(PromotionPolicyUtil.promotionPolicyStatus((String)templateEditVo.getEnableStatus(), (String)templateEditVo.getBeginTime(), (String)templateEditVo.getEndTime()));
        if (null == map) {
            return templateEditVo;
        }
        templateEditVo.setPromotionPolicyStatusName((String)map.get(templateEditVo.getPromotionPolicyStatus()));
        if ("ALL".equals(templateEditVo.getChanel())) {
            templateEditVo.setChanel(null);
        }
        if ("ALL".equals(templateEditVo.getSaleCompanyCode())) {
            templateEditVo.setSaleCompanyCode(null);
            templateEditVo.setSaleCompanyName(null);
        }
        return templateEditVo;
    }

    private void doUpdate(PromotionPolicyEntity oldEntity, PromotionPolicyEditReqVo vo) {
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionPolicyEntity.class));
        String timeActive = PromotionPolicyUtil.timeActive((String)oldEntity.getBeginTime(), (String)oldEntity.getEndTime());
        if (PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode().equals(timeActive)) {
            this.promotionPolicyMapper.updateNullValById(entity);
        } else if (PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode().equals(timeActive)) {
            long now = System.currentTimeMillis() / 1000L;
            if (now > CrmDateUtils.parseyyyyMMddHHmmss((String)vo.getEndTime()).toEpochSecond(ZoneOffset.of("+8"))) {
                throw new BusinessException("\u6267\u884c\u4e2d\u7684\u653f\u7b56\u53ea\u53ef\u7f16\u8f91\u7ed3\u675f\u65f6\u95f4\u8c03\u6574\u81f3\u5f53\u524d\u65f6\u95f4\u4e4b\u540e\u7684\u65f6\u95f4\u70b9");
            }
            entity = new PromotionPolicyEntity();
            entity.setId(vo.getId());
            entity.setEndTime(vo.getEndTime());
        } else {
            throw new BusinessException("\u8be5\u653f\u7b56\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
        }
        this.promotionPolicyMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<PromotionPolicyPageResp> getPageList(PromotionPolicyQueryVo vo) {
        Page page = PageUtil.buildPage((Integer)vo.getPageNum(), (Integer)vo.getPageSize());
        List<PromotionPolicyPageResp> list = this.promotionPolicyMapper.findList((Page<PromotionPolicyQueryVo>)page, vo);
        Map map = DictUtil.getDictValueMapsByCodes((String)"promotion_policy_status");
        list.forEach(v -> {
            if ("ALL".equals(v.getChanel())) {
                v.setChanel(null);
            }
            if ("ALL".equals(v.getSaleCompanyCode())) {
                v.setSaleCompanyCode(null);
                v.setSaleCompanyName(null);
            }
            v.setPromotionPolicyStatusNoEnableStatus(PromotionPolicyUtil.promotionPolicyStatusNoEnable((String)v.getBeginTime(), (String)v.getEndTime()));
            v.setPromotionPolicyStatus(PromotionPolicyUtil.promotionPolicyStatus((String)v.getEnableStatus(), (String)v.getBeginTime(), (String)v.getEndTime()));
            if (null == map) {
                return;
            }
            v.setPromotionPolicyStatusName((String)map.get(v.getPromotionPolicyStatus()));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<PromotionPolicyEntity> getListByTemplate(String templateId, String templateCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            wrapper.in((Object)"template_id", new Object[]{templateId});
        } else if (StringUtils.isNotBlank((CharSequence)templateCode)) {
            wrapper.in((Object)"template_code", new Object[]{templateCode});
        }
        return this.promotionPolicyMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public void del(List<String> promotionPolicyIds) {
        this.delCheck(promotionPolicyIds);
        this.promotionPolicyRuleService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyScopeService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyProductService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        for (String id : promotionPolicyIds) {
            PromotionPolicyVo promotionPolicyVo = this.findById(id);
            this.crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj((String)"menuCode").toString(), promotionPolicyVo.getId(), null, (Object)promotionPolicyVo);
        }
        this.promotionPolicyMapper.deleteBatchIds(promotionPolicyIds);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), promotionPolicyIds);
        PromotionUtil.deleteCaches(this.findByIds(Lists.newArrayList(promotionPolicyIds)).stream().map(PromotionPolicyVo::getPromotionPolicyCode).collect(Collectors.toList()));
    }

    private void delCheck(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        List entities = this.promotionPolicyMapper.selectBatchIds(promotionPolicyIds);
        HashSet temp = Sets.newHashSet();
        for (PromotionPolicyEntity entity : entities) {
            String timeActive = PromotionPolicyUtil.timeActive((String)entity.getBeginTime(), (String)entity.getEndTime());
            if (PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode().equals(timeActive)) continue;
            temp.add(entity.getPromotionPolicyCode());
        }
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return;
        }
        throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u653f\u7b56[" + temp.stream().collect(Collectors.joining(", ")) + "]\u4e3a\u6267\u884c\u4e2d\u6216\u5df2\u7ed3\u675f\u72b6\u6001\uff01");
    }

    @Override
    public void enable(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        this.updateStatus(promotionPolicyIds, CrmEnableStatusEnum.ENABLE);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), promotionPolicyIds);
        PromotionUtil.deleteCaches(this.findByIds(Lists.newArrayList(promotionPolicyIds)).stream().map(PromotionPolicyVo::getPromotionPolicyCode).collect(Collectors.toList()));
    }

    @Override
    public void disable(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        this.updateStatus(promotionPolicyIds, CrmEnableStatusEnum.DISABLE);
        this.countBeginAndEndAffectedCustoms(DateUtil.getDate((String)"yyyy-MM-dd"), promotionPolicyIds);
        PromotionUtil.deleteCaches(this.findByIds(Lists.newArrayList(promotionPolicyIds)).stream().map(PromotionPolicyVo::getPromotionPolicyCode).collect(Collectors.toList()));
    }

    private void updateStatus(List<String> promotionPolicyIds, CrmEnableStatusEnum statusEnum) {
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", promotionPolicyIds);
        PromotionPolicyEntity entity = new PromotionPolicyEntity();
        entity.setEnableStatus(statusEnum.getCode());
        this.promotionPolicyMapper.update((Object)entity, (Wrapper)wrapper);
    }

    private LoadConfigInfoContext loadConfigInfoContext(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        LoadConfigInfoContext loadConfigInfoContext = new LoadConfigInfoContext(configInfoQueryVo);
        String custCode = configInfoQueryVo.getCustCode();
        String orgCode = configInfoQueryVo.getOrgCode();
        String terminalCode = configInfoQueryVo.getTerminalCode();
        Set<String> orgCodes = this.buildOrgCodes(custCode, orgCode);
        Set<String> terminalOrgCodes = this.buildOrgCodesByTerminal(terminalCode, orgCode);
        Set<String> promotionPolicyIdAsScope = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCodes);
        Set<String> promotionPolicyIdAsScopeTerminal = this.promotionPolicyScopeService.selectPromotionPolicyIdByTerminal(terminalCode, terminalOrgCodes);
        promotionPolicyIdAsScope.addAll(promotionPolicyIdAsScopeTerminal);
        configInfoQueryVo.getOrderProductInfos().forEach(v -> {
            this.loadProductPromotionPolicy(loadConfigInfoContext, promotionPolicyIdAsScope, v.getProductCode());
            List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos = loadConfigInfoContext.getProductMapPromotionPolicy().get(v.getProductCode());
            this.addHitDetail(promotionPolicyInfoVos, "custCode", custCode);
            this.addHitDetail(promotionPolicyInfoVos, "orgCodes", JsonPropertyUtil.toJsonString((Object)orgCodes));
        });
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(loadConfigInfoContext, CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(loadConfigInfoContext, CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        this.loadProductInfo(loadConfigInfoContext);
        return loadConfigInfoContext;
    }

    private void loadProductInfo(LoadConfigInfoContext loadConfigInfoContext) {
        HashMap productMap = Maps.newHashMap();
        Set<String> productCodeGiftY = loadConfigInfoContext.getCurrentProductCodesN();
        if (null != productCodeGiftY) {
            productCodeGiftY.forEach(v -> productMap.put(v, ApiResultUtil.objResult((Result)this.mdmProductFeign.detail(null, v), (boolean)true)));
        }
        loadConfigInfoContext.setCurrentProductInfoNMap(productMap);
    }

    private void loadProductPromotionPolicy(LoadConfigInfoContext loadConfigInfoContext, Set<String> promotionPolicyIdAsScope, String productCode) {
        Set<String> promotionPolicyIdAsProduct = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCode(productCode);
        List<String> merged = this.merge(promotionPolicyIdAsProduct, promotionPolicyIdAsScope);
        if (CollectionUtils.isEmpty(merged)) {
            return;
        }
        List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos = this.selectActivities((PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)loadConfigInfoContext.getConfigInfoQueryVo(), PromotionPolicyEntity.class)), merged);
        loadConfigInfoContext.putPromotionPolicyInfoVos(productCode, promotionPolicyInfoVos);
        this.addHitDetail(promotionPolicyInfoVos, "productCode", productCode);
        this.addHitDetail(promotionPolicyInfoVos, "promotionPolicyIdAsProduct", JsonPropertyUtil.toJsonString(promotionPolicyIdAsProduct));
        this.addHitDetail(promotionPolicyInfoVos, "promotionPolicyIdAsScope", JsonPropertyUtil.toJsonString(promotionPolicyIdAsScope));
    }

    private void filterPromotionPolicy(LoadConfigInfoContext context) {
        context.getProductMapPromotionPolicy().forEach((productCode, promotionPolicyInfoVos) -> {
            promotionPolicyInfoVos = promotionPolicyInfoVos.stream().filter(v -> {
                if (CollectionUtils.isEmpty(this.abstractFilters)) {
                    return true;
                }
                for (AbstractFilter filter : this.abstractFilters) {
                    if (filter.filter(v, context)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            context.putPromotionPolicyInfoVos((String)productCode, (List<PromotionPolicyInfoDataVo>)promotionPolicyInfoVos);
        });
    }

    private List<PromotionPolicyInfoDataVo> filterPromotionProductPolicy(LoadConfigInfoContext context, List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos) {
        List<PromotionPolicyInfoDataVo> promotionPolicyInfoDataVos = promotionPolicyInfoVos.stream().filter(v -> {
            if (CollectionUtils.isEmpty(this.abstractProductFilters)) {
                return true;
            }
            for (AbstractProductFilter filter : this.abstractProductFilters) {
                if (filter.filter(v, context)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return promotionPolicyInfoDataVos;
    }

    @Override
    public Map<String, List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoForOrder(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        this.checkConfigInfoQueryVo(configInfoQueryVo);
        LoadConfigInfoContext context = this.loadConfigInfoContext(configInfoQueryVo);
        List orderProductInfos = configInfoQueryVo.getOrderProductInfos();
        for (PromotionPolicyConfigInfoQueryVo.ProductOrderInfo info : orderProductInfos) {
            if (StringUtils.isBlank((CharSequence)info.getPromotionPolicyId())) continue;
            List<Object> dataVos = context.getProductMapPromotionPolicy().get(info.getProductCode());
            dataVos = dataVos.stream().filter(d -> info.getPromotionPolicyId().contains(d.getId())).collect(Collectors.toList());
            context.getProductMapPromotionPolicy().put(info.getProductCode(), dataVos);
        }
        this.filterPromotionPolicy(context);
        HashMap result = Maps.newHashMap();
        context.getProductMapPromotionPolicy().forEach((productCode, promotionPolicyInfoVos) -> {
            for (PromotionPolicyInfoDataVo infoVo : promotionPolicyInfoVos) {
                PromotionPolicyConfigInfo promotionPolicyConfigInfo = this.loadPromotionPolicyRuleInfo(infoVo);
                this.buildProductInfoGiftY(promotionPolicyConfigInfo, context);
                this.countingPromotionPolicyToProduct(context, promotionPolicyConfigInfo, result);
            }
        });
        this.calculateRuleExecute(result, configInfoQueryVo);
        result.forEach((k, v) -> {
            List n = v.stream().filter(s -> s.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData() == null).collect(Collectors.toList());
            v.removeAll(n);
        });
        return result;
    }

    private void calculateRuleExecute(Map<String, List<PromotionPolicyConfigInfo>> result, PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        if (null == result) {
            return;
        }
        List orderProductInfos = configInfoQueryVo.getOrderProductInfos();
        if (CollectionUtils.isEmpty((Collection)orderProductInfos)) {
            return;
        }
        result.forEach((s, promotionPolicyConfigInfos) -> {
            if (null == promotionPolicyConfigInfos) {
                return;
            }
            promotionPolicyConfigInfos.forEach(v -> {
                RuleExecuteParam ruleExecuteParam = new RuleExecuteParam();
                ruleExecuteParam.setPromotionPolicyConfigInfo((PromotionPolicyConfigInfo)v);
                ArrayList productOrderBuy = Lists.newArrayList();
                for (PromotionPolicyConfigInfoQueryVo.ProductOrderInfo productOrderInfo : orderProductInfos) {
                    if (!s.contains(productOrderInfo.getProductCode())) continue;
                    productOrderBuy.add(new RuleExecuteParam.ProductOrderBuy(productOrderInfo));
                }
                if (CollectionUtils.isEmpty((Collection)productOrderBuy)) {
                    return;
                }
                ruleExecuteParam.setProductOrderBuy(productOrderBuy);
                ruleExecuteParam.setCusCode(configInfoQueryVo.getCustCode());
                ruleExecuteParam.setCusTypeCode(configInfoQueryVo.getCusTypeCode());
                ruleExecuteParam.setCusOrgCode(configInfoQueryVo.getOrgCode());
                Object ruleResponse = this.defaultRuleExecutor.execute(ruleExecuteParam);
                PromotionPolicyInfoDataVo configInfo = v.getPromotionPolicyInfoVo();
                if (null != configInfo) {
                    configInfo.setCalculateRuleResponse(ruleResponse);
                }
            });
        });
    }

    @Override
    public List<PromotionPolicyConfigInfo> loadPromotionPolicyConfigInfoByProductCode(QueryProductPolicyParamVo productPolicyParamVo) {
        if (StringUtils.isBlank((CharSequence)productPolicyParamVo.getProductCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1\u7f16\u7801");
        }
        List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos = this.loadPromotionPolicyInfos(productPolicyParamVo);
        if (CollectionUtils.isEmpty(promotionPolicyInfoVos)) {
            return Lists.newArrayList();
        }
        LoadConfigInfoContext context = new LoadConfigInfoContext();
        context.setPromotionPolicyIds(promotionPolicyInfoVos.stream().map(UuidVo::getId).collect(Collectors.toSet()));
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(context, CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        this.promotionPolicyProductService.selectGiftByPromotionPolicyId(context, CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        this.loadProductInfo(context);
        ArrayList configInfos = Lists.newArrayList();
        for (PromotionPolicyInfoDataVo infoVo : promotionPolicyInfoVos) {
            PromotionPolicyConfigInfo promotionPolicyConfigInfo = this.loadPromotionPolicyRuleInfo(infoVo);
            this.buildProductInfoGiftY(promotionPolicyConfigInfo, context);
            configInfos.add(promotionPolicyConfigInfo);
        }
        return configInfos;
    }

    @Override
    public PromotionPolicyVo findById(String promotionPolicyId) {
        if (StringUtils.isBlank((CharSequence)promotionPolicyId)) {
            return null;
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)this.promotionPolicyMapper.selectOne((Wrapper)Wrappers.query().in((Object)"id", new Object[]{promotionPolicyId})));
        return (PromotionPolicyVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyVo.class);
    }

    @Override
    public List<PromotionPolicyVo> findByIds(ArrayList<String> promotionPolicyIds) {
        if (CollectionUtil.listEmpty(promotionPolicyIds)) {
            return Lists.newArrayList();
        }
        List entitys = this.promotionPolicyMapper.selectList((Wrapper)Wrappers.query().in((Object)"id", promotionPolicyIds));
        return CrmBeanUtil.copyList((List)entitys, PromotionPolicyVo.class);
    }

    @Override
    public Map<String, List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoForSelect(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        ValidateUtils.validate((Object)configInfoQueryVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.notEmpty((Collection)configInfoQueryVo.getOrderProductInfos(), (String)"\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        List orderInfos = configInfoQueryVo.getOrderProductInfos();
        TreeMap result = Maps.newTreeMap();
        TreeMap productMap = Maps.newTreeMap();
        Map<String, List<PromotionPolicyConfigInfo>> orderResult = this.loadPromotionPolicyConfigInfoForOrder(configInfoQueryVo);
        result.putAll(orderResult);
        orderInfos.forEach(info -> {
            QueryProductPolicyParamVo productParam = new QueryProductPolicyParamVo();
            productParam.setCustCode(configInfoQueryVo.getCustCode());
            productParam.setOrgCode(configInfoQueryVo.getOrgCode());
            productParam.setProductCode(info.getProductCode());
            productParam.setTerminalCode(configInfoQueryVo.getTerminalCode());
            List<PromotionPolicyConfigInfo> productResult = this.loadPromotionPolicyConfigInfoByProductCode(productParam);
            productMap.put(info.getProductCode(), productResult);
            List infoList = (List)orderResult.get(info.getProductCode());
            if (CollectionUtil.listEmpty((List)infoList)) {
                productResult.forEach(p -> p.setHit(false));
            } else {
                Set<String> orderPromotionCodes = infoList.stream().collect(Collectors.groupingBy(i -> i.getPromotionPolicyInfoVo().getPromotionPolicyCode())).keySet();
                productResult.stream().forEach(p -> {
                    if (!orderPromotionCodes.contains(p.getPromotionPolicyInfoVo().getPromotionPolicyCode())) {
                        p.setHit(false);
                    } else {
                        PromotionPolicyConfigInfo configInfo = (PromotionPolicyConfigInfo)infoList.stream().filter(i -> Objects.equals(i.getPromotionPolicyInfoVo().getPromotionPolicyCode(), p.getPromotionPolicyInfoVo().getPromotionPolicyCode())).collect(Collectors.toList()).get(0);
                        productResult.remove(p);
                        productResult.add(configInfo);
                    }
                });
            }
        });
        result.putAll(productMap);
        return result;
    }

    @Override
    public Map<String, List<PromotionPolicyConfigInfo>> findProductMapByCusCode(String cusCode) {
        if (StringUtils.isBlank((CharSequence)cusCode)) {
            return Maps.newHashMap();
        }
        Set<String> promotionIds = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(cusCode, Sets.newHashSet());
        if (!CollectionUtil.collectionNotEmpty(promotionIds)) {
            return Maps.newHashMap();
        }
        List<PromotionPolicyVo> promotionPolicyVos = this.findByIds(Lists.newArrayList(promotionIds));
        Map<String, PromotionPolicyVo> promotionPolicyVoMap = promotionPolicyVos.stream().collect(Collectors.toMap(UuidVo::getId, a -> a));
        Map<String, List<PromotionPolicyProductEntity>> productMap = this.promotionPolicyProductService.findProductsByPromotionIds(Lists.newArrayList(promotionIds), CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        HashMap result = Maps.newHashMap();
        productMap.values().forEach(products -> products.forEach(p -> {
            List promotions = (List)result.get(p.getProductCode());
            if (promotions == null) {
                promotions = Lists.newArrayList();
            }
            PromotionPolicyInfoDataVo promotionPolicyInfoDataVo = (PromotionPolicyInfoDataVo)CrmBeanUtil.copy(promotionPolicyVoMap.get(p.getPromotionPolicyId()), PromotionPolicyInfoDataVo.class);
            PromotionPolicyConfigInfo info = new PromotionPolicyConfigInfo();
            info.setPromotionPolicyInfoVo(promotionPolicyInfoDataVo);
            promotions.add(info);
            result.put(p.getProductCode(), promotions);
        }));
        return result;
    }

    @Override
    public PromotionPolicyVo findByCode(String promotionPolicyCode) {
        if (StringUtils.isBlank((CharSequence)promotionPolicyCode)) {
            return null;
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)this.promotionPolicyMapper.selectOne((Wrapper)Wrappers.query().eq((Object)"promotion_policy_code", (Object)promotionPolicyCode)));
        PromotionPolicyVo vo = (PromotionPolicyVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyVo.class);
        if (vo == null) {
            return null;
        }
        PromotionPolicyTemplateVo templateVo = this.promotionPolicyTemplateService.findByCode(vo.getTemplateCode());
        vo.setPromotionPolicyTemplateVo(templateVo);
        return vo;
    }

    public Map<String, PromotionPolicyConfigInfo> searchPromotionToOrder(PromotionPolicyForOrderReqVo promotionPolicyForOrderReqVo) {
        List promotionList;
        if (promotionPolicyForOrderReqVo == null) {
            Maps.newHashMap();
        }
        if (CollectionUtil.listEmpty((List)(promotionList = promotionPolicyForOrderReqVo.getPromotionList()))) {
            return Maps.newHashMap();
        }
        Set<String> productCodes = promotionList.stream().collect(Collectors.toMap(PromotionPolicyForOrderProductReqVo::getProductCode, a -> a, (a, b) -> a)).keySet();
        HashMap result = Maps.newHashMap();
        productCodes.forEach(p -> {
            QueryProductPolicyParamVo param = new QueryProductPolicyParamVo();
            param.setCustCode(promotionPolicyForOrderReqVo.getCusCode());
            param.setOrgCode(promotionPolicyForOrderReqVo.getOrgCode());
            String[] ppArray = p.split(",");
            param.setProductCode(ppArray[0]);
            List<PromotionPolicyConfigInfo> promotionPolicyConfigInfos = this.loadPromotionPolicyConfigInfoByProductCode(param);
            if (CollectionUtil.listNotEmpty(promotionPolicyConfigInfos)) {
                promotionPolicyConfigInfos.forEach(pr -> {
                    String promotionCode = pr.getPromotionPolicyInfoVo().getPromotionPolicyCode();
                    result.put(String.join((CharSequence)",", p, promotionCode), pr);
                });
            }
        });
        return result;
    }

    private PromotionPolicyConfigInfo loadPromotionPolicyRuleInfo(PromotionPolicyInfoDataVo infoVo) {
        List<PromotionPolicyRuleEntity> promotionPolicyRules = this.promotionPolicyRuleService.getRuleByPromotionPolicyIdOrCode(infoVo.getId(), null);
        Map<String, List<PromotionPolicyRuleEntity>> rulesMapAsPolicyRules = promotionPolicyRules.stream().collect(Collectors.groupingBy(PromotionPolicyRuleEntity::getRuleType));
        PromotionPolicyRuleEntity conditionAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.condition.name()).get(0);
        PromotionPolicyRuleEntity calculateAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.calculate.name()).get(0);
        List<PromotionPolicyRuleEntity> limitedAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.limited.name());
        Set<String> ruleIds = promotionPolicyRules.stream().map(PromotionPolicyRuleEntity::getPromotionRuleId).collect(Collectors.toSet());
        Map<String, List<PromotionRuleEntity>> rulesMap = this.promotionRuleService.getListByIds(ruleIds).stream().collect(Collectors.groupingBy(PromotionRuleEntity::getRuleType));
        PromotionRuleEntity condition = rulesMap.get(PromotionRuleVo.RULE_TYPE.condition.name()).get(0);
        PromotionRuleEntity calculate = rulesMap.get(PromotionRuleVo.RULE_TYPE.calculate.name()).get(0);
        PromotionPolicyRuleVo calculateRuleVo = (PromotionPolicyRuleVo)CrmBeanUtil.copy((Object)((Object)calculateAsPolicyRules), PromotionPolicyRuleVo.class);
        calculateRuleVo.setFuncBody(calculate.getFuncBody());
        PromotionPolicyRuleVo conditionRuleVo = (PromotionPolicyRuleVo)CrmBeanUtil.copy((Object)((Object)conditionAsPolicyRules), PromotionPolicyRuleVo.class);
        conditionRuleVo.setFuncBody(condition.getFuncBody());
        List limitedRuleVo = CrmBeanUtil.copyList(limitedAsPolicyRules, PromotionPolicyRuleVo.class);
        List<PromotionRuleEntity> limitedTemp = rulesMap.get(PromotionRuleVo.RULE_TYPE.limited.name());
        HashMap limited = null == limitedTemp ? Maps.newHashMap() : limitedTemp.stream().collect(Collectors.toMap(PromotionRuleEntity::getRuleCode, v -> v, (t, t2) -> t2));
        limitedRuleVo.forEach(v -> {
            PromotionRuleEntity temp = (PromotionRuleEntity)((Object)((Object)limited.get(v.getRuleCode())));
            if (null != temp) {
                v.setFuncBody(temp.getFuncBody());
            }
        });
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = new PromotionPolicyConfigInfo();
        promotionPolicyConfigInfo.setPromotionPolicyInfoVo(infoVo);
        promotionPolicyConfigInfo.setCalculate(calculateRuleVo);
        promotionPolicyConfigInfo.setCondition(conditionRuleVo);
        promotionPolicyConfigInfo.setLimited(limitedRuleVo);
        return promotionPolicyConfigInfo;
    }

    private void countingPromotionPolicyToProduct(LoadConfigInfoContext context, PromotionPolicyConfigInfo promotionPolicyConfigInfo, Map<String, List<PromotionPolicyConfigInfo>> result) {
        Map<String, PromotionPolicyProductEntity> currentProduct = context.getCurrentProductY().get(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getId());
        if (CollectionUtils.isEmpty(currentProduct)) {
            return;
        }
        String productCodes = currentProduct.keySet().stream().collect(Collectors.joining(","));
        if (StringUtils.isBlank((CharSequence)productCodes)) {
            return;
        }
        ArrayList configInfos = result.get(productCodes);
        if (null == configInfos) {
            configInfos = Lists.newArrayList();
        }
        if (context.isDuplicationPromotionPolicy(productCodes, promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getId())) {
            return;
        }
        configInfos.add(promotionPolicyConfigInfo);
        result.put(productCodes, configInfos);
    }

    private void buildProductInfoGiftY(PromotionPolicyConfigInfo promotionPolicyConfigInfo, LoadConfigInfoContext context) {
        Map<String, MdmProductRespVo> currentProductInfoNMap = context.getCurrentProductInfoNMap();
        String promotionPolicyId = promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getId();
        Map<String, PromotionPolicyProductEntity> currentProductN = context.getCurrentProductN().get(promotionPolicyId);
        ArrayList productsGift = Lists.newArrayList();
        currentProductN.forEach((productCode, entity) -> {
            MdmProductRespVo productRespVo = (MdmProductRespVo)currentProductInfoNMap.get(productCode);
            if (null != productRespVo) {
                productsGift.add(productRespVo);
            }
        });
        promotionPolicyConfigInfo.setProductsGift((List)productsGift);
    }

    private void checkConfigInfoQueryVo(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        if (null == configInfoQueryVo) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)configInfoQueryVo.getCustCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (CollectionUtils.isEmpty((Collection)configInfoQueryVo.getOrderProductInfos())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        }
        configInfoQueryVo.getOrderProductInfos().forEach(v -> {
            if (StringUtils.isBlank((CharSequence)v.getProductCode())) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1\u7f16\u7801");
            }
            if (null == v.getProductBuyNo()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u8d2d\u4e70\u6570\u91cf");
            }
            if (null == v.getProductBuyAmount()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u8d2d\u4e70\u91d1\u989d");
            }
        });
    }
}

