/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.handler;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.util.CommonConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderPromotionHandlerExpand"})
@Component(value="orderPromotionHandler")
public class OrderPromotionHandler {
    @Resource
    private PromotionPolicyService promotionPolicyService;

    public OrderVo handle(OrderVo orderVo, String cusCode, String orgCode) {
        PromotionPolicyConfigInfoQueryVo promotionPolicyConfigInfoQueryVo = this.packagePromotionParm(orderVo, cusCode, orgCode);
        orderVo = this.setZeroPromotionAmountForGroup(orderVo);
        if (null == promotionPolicyConfigInfoQueryVo) {
            return orderVo;
        }
        Map<String, List<PromotionPolicyConfigInfo>> promotionMap = this.promotionPolicyService.loadPromotionPolicyConfigInfoForOrder(promotionPolicyConfigInfoQueryVo);
        return this.calPromotion(orderVo, promotionMap);
    }

    public OrderVo calPromotion(OrderVo orderVo, Map<String, List<PromotionPolicyConfigInfo>> promotionMap) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) continue;
            BigDecimal promotionAmount = BigDecimal.ZERO;
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                BigDecimal oldAmount;
                StringBuilder stb;
                if (StringUtils.isEmpty((CharSequence)item.getPromotionPolicyCode())) continue;
                PromotionPolicyConfigInfo promotionPolicyConfigInfo = this.findPromotionByCode(promotionMap.get(item.getProductCode()), item.getPromotionPolicyCode());
                if (null == promotionPolicyConfigInfo) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb2 = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(item.getPromotionPolicyName()).append("\u3011\u4e0d\u53ef\u7528\uff01");
                    item.setCalSucessMsg(stb2.toString());
                    groupItemVo.setGiftList(new ArrayList());
                    continue;
                }
                CalculateRuleResponse calculateRuleResponse = promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse();
                if (null == calculateRuleResponse.getResultData()) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(item.getPromotionPolicyName()).append("\u3011\u672c\u54c1\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff01").append(calculateRuleResponse.getNoLadderMatchMsg());
                    item.setCalSucessMsg(stb.toString());
                    item.setPromotionPolicyCode("");
                    item.setPromotionPolicyName("");
                    item.setPromotionPolicyId("");
                    if (!promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) continue;
                    groupItemVo.setGiftList(new ArrayList());
                    continue;
                }
                if (promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) {
                    item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                    item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                    item.setPromotionResultType((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                    item.setPromotionResultDate((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                    item.setAmount(item.getAmount().subtract(calculateRuleResponse.getResultData()).setScale(6, 4));
                    promotionAmount = promotionAmount.add(calculateRuleResponse.getResultData());
                    continue;
                }
                if (promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())) {
                    item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                    item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                    item.setPromotionResultType((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                    item.setPromotionResultDate((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                    oldAmount = item.getAmount();
                    item.setAmount(item.getAmount().multiply(calculateRuleResponse.getResultData()).setScale(6, 4));
                    promotionAmount = promotionAmount.add(oldAmount.multiply(BigDecimal.ONE.subtract(calculateRuleResponse.getResultData())).setScale(6, 4));
                    continue;
                }
                if (promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())) {
                    item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                    item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                    item.setPromotionResultType((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                    item.setPromotionResultDate((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                    oldAmount = item.getAmount();
                    item.setAmount(item.getProductNum().multiply(calculateRuleResponse.getResultData()).setScale(6, 4));
                    promotionAmount = promotionAmount.add(oldAmount.subtract(item.getAmount()));
                    continue;
                }
                if (!promotionPolicyConfigInfo.getCalculate().getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
                item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                item.setPromotionResultType((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                item.setPromotionResultDate((Object)promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                if (!this.validateGift(groupItemVo.getGiftList(), promotionPolicyConfigInfo.getProductsGift(), calculateRuleResponse)) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(item.getPromotionPolicyName()).append("\u3011\u8d60\u54c1\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01").append(calculateRuleResponse.getNoLadderMatchMsg());
                    item.setCalSucessMsg(stb.toString());
                    item.setPromotionPolicyCode("");
                    item.setPromotionPolicyName("");
                    item.setPromotionPolicyId("");
                    groupItemVo.setGiftList(new ArrayList());
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) continue;
                for (OrderDetailVo gift : groupItemVo.getGiftList()) {
                    promotionAmount = promotionAmount.add(gift.getProductNum().multiply(gift.getPrice()).setScale(6, 4));
                }
            }
            groupItemVo.setPromotionAmount(promotionAmount);
        }
        return orderVo;
    }

    public boolean validateGift(List<OrderDetailVo> giftList, List<MdmProductRespVo> productsGift, CalculateRuleResponse calculateRuleResponse) {
        for (OrderDetailVo item : giftList) {
            MdmProductRespVo gift = this.findGiftByProductCode(productsGift, item.getProductCode());
            if (null == gift) {
                return false;
            }
            if (!(calculateRuleResponse.getResultDataType().equals(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode()) ? item.getProductNum().intValue() != calculateRuleResponse.getResultData().intValue() : item.getAmount().compareTo(calculateRuleResponse.getResultData()) != 0)) continue;
            return false;
        }
        return true;
    }

    public MdmProductRespVo findGiftByProductCode(List<MdmProductRespVo> productsGift, String productCode) {
        if (CollectionUtils.isEmpty(productsGift)) {
            return null;
        }
        for (MdmProductRespVo gift : productsGift) {
            if (!gift.getProductCode().equals(productCode)) continue;
            return gift;
        }
        return null;
    }

    public PromotionPolicyConfigInfo findPromotionByCode(List<PromotionPolicyConfigInfo> promotionPolicyConfigInfos, String promotionCode) {
        if (CollectionUtils.isEmpty(promotionPolicyConfigInfos)) {
            return null;
        }
        for (PromotionPolicyConfigInfo info : promotionPolicyConfigInfos) {
            if (!info.getPromotionPolicyInfoVo().getPromotionPolicyCode().equals(promotionCode)) continue;
            return info;
        }
        return null;
    }

    public OrderVo setZeroPromotionAmountForGroup(OrderVo orderVo) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            groupItemVo.setPromotionAmount(BigDecimal.ZERO);
        }
        return orderVo;
    }

    public PromotionPolicyConfigInfoQueryVo packagePromotionParm(OrderVo orderVo, String cusCode, String orgCode) {
        PromotionPolicyConfigInfoQueryVo promotionPolicyConfigInfoQueryVo = new PromotionPolicyConfigInfoQueryVo();
        promotionPolicyConfigInfoQueryVo.setCustCode(cusCode);
        promotionPolicyConfigInfoQueryVo.setOrgCode(orgCode);
        ArrayList<PromotionPolicyConfigInfoQueryVo.ProductOrderInfo> orderProductInfos = new ArrayList<PromotionPolicyConfigInfoQueryVo.ProductOrderInfo>();
        promotionPolicyConfigInfoQueryVo.setOrderProductInfos(orderProductInfos);
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) continue;
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                if (StringUtils.isEmpty((CharSequence)item.getPromotionPolicyCode())) continue;
                PromotionPolicyConfigInfoQueryVo.ProductOrderInfo productOrderInfo = new PromotionPolicyConfigInfoQueryVo.ProductOrderInfo();
                productOrderInfo.setProductCode(item.getProductCode());
                productOrderInfo.setProductBuyNo(item.getProductNum());
                productOrderInfo.setProductBuyAmount(item.getAmount());
                productOrderInfo.setPromotionPolicyId(item.getPromotionPolicyId());
                orderProductInfos.add(productOrderInfo);
            }
        }
        if (CollectionUtils.isEmpty(orderProductInfos)) {
            return null;
        }
        return promotionPolicyConfigInfoQueryVo;
    }
}

