/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans.scopefilters;

import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.promotion.enums.ScopeTypeDynamicEnum;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.beans.AbstractScopeFilter;
import com.biz.crm.promotion.service.npromotion.vo.PromotionHitReq;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"cusScopeFilterExtendImpl"})
public class CusScopeFilterImpl
extends AbstractScopeFilter {
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private PromotionPolicyScopeService promotionPolicyScopeService;
    @Resource
    private PromotionService promotionService;

    @Override
    public List<String> apply(PromotionHitReq param) {
        MdmCustomerMsgRespVo customerMsg;
        if (param == null || StringUtils.isEmpty((String)param.getAccountType()) || !Objects.equals(param.getAccountType(), AccountTypeDynamicEnum.CUSTOMER.getCode()) || StringUtils.isEmpty((String)param.getAccountCode())) {
            return Lists.newArrayList();
        }
        String orgCode = StringUtils.isNotEmpty((String)param.getOrgCode()) ? param.getOrgCode() : ((customerMsg = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, param.getAccountCode()).getResult()) == null ? null : customerMsg.getOrgCode());
        List orgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf((String)orgCode);
        ArrayList channelList = Lists.newArrayList((Object[])new String[]{param.getChannelCode()});
        List[] unitCodes = new List[]{Lists.newArrayList((Object[])new String[]{param.getAccountCode()}), orgCodeList, channelList};
        ScopeTypeDynamicEnum[] scopeTypes = AccountTypeDynamicEnum.CUSTOMER.getScopeTypes();
        ArrayList scopeTypeCodes = Lists.newArrayList();
        for (ScopeTypeDynamicEnum scopeTypeDynamicEnum : scopeTypes) {
            scopeTypeCodes.add(scopeTypeDynamicEnum.getCode());
        }
        List<String> promotionCodes = this.promotionPolicyScopeService.findPromotionCodesByAccounts(unitCodes, scopeTypeCodes.toArray(new String[scopeTypeCodes.size()]));
        List<String> filerPromotionCodes = this.promotionService.findAvailableByCodes(promotionCodes);
        return filerPromotionCodes;
    }
}

