/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.util;

import com.biz.crm.promotion.enums.RuleTypeDynamicEnum;
import com.biz.crm.promotion.enums.ScopeTypeDynamicEnum;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.vo.PromotionEditVo;
import com.biz.crm.promotion.service.npromotion.vo.PromotionProductVo;
import com.biz.crm.promotion.service.npromotion.vo.PromotionRuleVo;
import com.biz.crm.promotion.service.npromotion.vo.PromotionScopeVo;
import com.biz.crm.promotion.util.RedisCacheUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PromotionUtil {
    public static final String PRODUCT_CURRENTS = "currentProducts";
    public static final String PRODUCT_GIFTS = "giftProducts";

    public static String formatProductObjectName(String productType) {
        if (Objects.equals(productType, CommonConstant.GLOBAL.YesOrNo.Y.getItemCode())) {
            return PRODUCT_CURRENTS;
        }
        return PRODUCT_GIFTS;
    }

    public static List<PromotionScopeVo> parseScopeMap(PromotionEditVo promotionEditVo) {
        if (Objects.isNull((Object)promotionEditVo) || CollectionUtil.mapEmpty(promotionEditVo.getScopeMap())) {
            return Lists.newArrayList();
        }
        Map<String, List<PromotionScopeVo>> scopeMap = promotionEditVo.getScopeMap();
        ArrayList scopeVos = Lists.newArrayList();
        scopeMap.forEach((k, v) -> {
            ScopeTypeDynamicEnum scopeTypeDynamicEnum = ScopeTypeDynamicEnum.getScopeTypeEnumsByObjectName(k);
            ValidateUtils.validate((Object)scopeTypeDynamicEnum, (String)"\u6839\u636e\u4fc3\u9500\u8303\u56f4\u53c2\u6570\u540d\u79f0\u3010%s\u3011\u6ca1\u6709\u83b7\u53d6\u5230\u5b57\u5178\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u4f20\u5165", (Object[])new Object[]{k});
            ValidateUtils.isTrue((Objects.equals(scopeTypeDynamicEnum.getContainName(), k) || Objects.equals(scopeTypeDynamicEnum.getUnContainName(), k) ? 1 : 0) != 0, (String)"\u4fc3\u9500\u8303\u56f4\u53c2\u6570\u4f20\u5165\u9519\u8bef\uff0c\u6ca1\u6709\u5339\u914d\u5230\u53c2\u6570\u540d\uff1a[%s]\uff0c\u6b63\u786e\u7684\u53c2\u6570\u540d\u5e94\u8be5\u662fscope + \u5b57\u5178\u7f16\u7801 + Y|N", (Object[])new Object[]{k});
            if (CollectionUtil.listNotEmpty((List)v)) {
                v.forEach(scope -> {
                    scope.setContainable(k.substring(k.length() - 1));
                    scope.setScopeType(scopeTypeDynamicEnum.getCode());
                    scope.setPromotionPolicyId(promotionEditVo.getId());
                    scope.setPromotionPolicyCode(promotionEditVo.getPromotionPolicyCode());
                    scope.setPromotionPolicyName(promotionEditVo.getPromotionPolicyName());
                    scopeVos.add(scope);
                });
            }
        });
        return scopeVos;
    }

    public static List<PromotionRuleVo> parseRuleMap(PromotionEditVo promotionEditVo) {
        if (Objects.isNull((Object)promotionEditVo) || CollectionUtil.mapEmpty(promotionEditVo.getRuleMap())) {
            return Lists.newArrayList();
        }
        Map<String, List<PromotionRuleVo>> ruleMap = promotionEditVo.getRuleMap();
        ArrayList ruleVos = Lists.newArrayList();
        ruleMap.forEach((k, v) -> {
            RuleTypeDynamicEnum ruleTypeDynamicEnum = RuleTypeDynamicEnum.getRuleTypeEnumByObjectName(k);
            ValidateUtils.validate((Object)ruleTypeDynamicEnum, (String)"\u6839\u636e\u4fc3\u9500\u89c4\u5219\u53c2\u6570\u540d\u79f0\u3010%s\u3011\u6ca1\u6709\u83b7\u53d6\u5230\u5b57\u5178\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u4f20\u5165", (Object[])new Object[]{k});
            ValidateUtils.isTrue((boolean)Objects.equals(ruleTypeDynamicEnum.getObjectName(), k), (String)"\u4fc3\u9500\u89c4\u5219\u53c2\u6570\u4f20\u5165\u9519\u8bef\uff0c\u6ca1\u6709\u5339\u914d\u5230\u53c2\u6570\u540d\uff1a[%s]\uff0c\u6b63\u786e\u7684\u53c2\u6570\u540d\u5e94\u8be5\u662f \u5b57\u5178\u7f16\u7801 + s", (Object[])new Object[]{k});
            if (CollectionUtil.listNotEmpty((List)v)) {
                v.forEach(rule -> {
                    rule.setRuleType(ruleTypeDynamicEnum.getCode());
                    rule.setPromotionPolicyId(promotionEditVo.getId());
                    rule.setPromotionPolicyCode(promotionEditVo.getPromotionPolicyCode());
                    rule.setPromotionPolicyTemplateId(promotionEditVo.getTemplateId());
                    rule.setPromotionPolicyTemplateCode(promotionEditVo.getTemplateCode());
                    ruleVos.add(rule);
                });
            }
        });
        return ruleVos;
    }

    public static List<PromotionProductVo> parseProductMap(PromotionEditVo promotionEditVo) {
        if (Objects.isNull((Object)promotionEditVo) || CollectionUtil.mapEmpty(promotionEditVo.getProductMap())) {
            return Lists.newArrayList();
        }
        Map<String, List<PromotionProductVo>> productMap = promotionEditVo.getProductMap();
        ArrayList productVos = Lists.newArrayList();
        productMap.forEach((k, v) -> {
            if (CollectionUtil.listEmpty((List)v)) {
                return;
            }
            v.forEach(product -> {
                product.setPromotionPolicyId(promotionEditVo.getId());
                product.setPromotionPolicyCode(promotionEditVo.getPromotionPolicyCode());
                product.setPromotionPolicyName(promotionEditVo.getPromotionPolicyName());
                if (Objects.equals(PRODUCT_CURRENTS, k)) {
                    product.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
                    productVos.add(product);
                } else if (Objects.equals(PRODUCT_GIFTS, k)) {
                    product.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
                    productVos.add(product);
                }
            });
        });
        return productVos;
    }

    public static Map<String, List<PromotionScopeVo>> formatScopeMap(List<PromotionScopeVo> scopeVos) {
        if (CollectionUtil.listEmpty(scopeVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<PromotionScopeVo>> scopeMap = scopeVos.stream().collect(Collectors.groupingBy(scope -> ScopeTypeDynamicEnum.buildObjectName(scope.getScopeType(), scope.getContainable())));
        if (CollectionUtil.mapEmpty(scopeMap)) {
            return Maps.newHashMap();
        }
        return scopeMap;
    }

    public static Map<String, List<PromotionRuleVo>> formatRuleMap(List<PromotionRuleVo> ruleVos) {
        if (CollectionUtil.listEmpty(ruleVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<PromotionRuleVo>> ruleMap = ruleVos.stream().collect(Collectors.groupingBy(rule -> RuleTypeDynamicEnum.buildObjectName(rule.getRuleType())));
        if (CollectionUtil.mapEmpty(ruleMap)) {
            return Maps.newHashMap();
        }
        return ruleMap;
    }

    public static Map<String, List<PromotionProductVo>> formatProductMap(List<PromotionProductVo> productVos) {
        if (CollectionUtil.listEmpty(productVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<PromotionProductVo>> productMap = productVos.stream().collect(Collectors.groupingBy(product -> PromotionUtil.formatProductObjectName(product.getCurrentProduct())));
        if (CollectionUtil.mapEmpty(productMap)) {
            return Maps.newHashMap();
        }
        return productMap;
    }

    public static PromotionEditVo getOneCache(String promotionCode, PromotionService promotionService) {
        if (StringUtils.isEmpty((String)promotionCode)) {
            return null;
        }
        PromotionEditVo vo = (PromotionEditVo)((Object)RedisCacheUtil.get(promotionCode));
        if (Objects.isNull((Object)vo)) {
            vo = promotionService.findDetailsByCode(promotionCode);
            PromotionUtil.setOneCache(promotionCode, vo);
        }
        return vo;
    }

    public static List<PromotionEditVo> getCacheList(List<String> promotionCodes, PromotionService promotionService) {
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        promotionCodes.forEach(code -> {
            PromotionEditVo oneCache = PromotionUtil.getOneCache(code, promotionService);
            if (oneCache == null) {
                return;
            }
            list.add(oneCache);
        });
        return list;
    }

    public static void setOneCache(String promotionCode, PromotionEditVo vo) {
        if (StringUtils.isEmpty((String)promotionCode) || Objects.isNull((Object)vo)) {
            return;
        }
        RedisCacheUtil.set(promotionCode, (Object)vo);
    }

    public static void deleteCaches(List<String> promotionCodes) {
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return;
        }
        RedisCacheUtil.delete(Lists.newArrayList(promotionCodes));
    }
}

