/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.eunm.dms.SaleGoalEunm;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.salegoal.service.SaleGoalService;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractSaleGoalListener")
@ConditionalOnMissingBean(name={"saleGoalContractListenerExtend"})
public class ContractSaleGoalListener
implements AbstractContractModelListener {
    @Resource
    private SaleGoalService saleGoalService;

    @Override
    @Transactional
    public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        if (CollectionUtil.jsonArrayEmpty((JSONArray)data)) {
            return new JSONArray();
        }
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SaleGoalVo> saleGoalVos = BeanCopyUtil.parseByJSONArray(data.getJSONArray(0), SaleGoalVo.class);
        if (CollectionUtil.listNotEmpty(saleGoalVos)) {
            saleGoalVos.forEach(vo -> this.buildBaseInfo((SaleGoalVo)vo, saleContractVo));
        }
        saleGoalVos = this.saleGoalService.replace(saleGoalVos, contractCode, indexCode, saleContractVo);
        return BeanCopyUtil.formatJSONArray(saleGoalVos);
    }

    @Override
    @Transactional
    public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SaleGoalVo> saleGoalVos = BeanCopyUtil.parseByJSONArray(data.getJSONArray(0), SaleGoalVo.class);
        if (CollectionUtil.listNotEmpty(saleGoalVos)) {
            saleGoalVos.forEach(vo -> this.buildBaseInfo((SaleGoalVo)vo, saleContractVo));
        }
        saleGoalVos = this.saleGoalService.replace(saleGoalVos, contractCode, indexCode, saleContractVo);
        return BeanCopyUtil.formatJSONArray(saleGoalVos);
    }

    @Override
    public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
        if (StringUtils.isEmpty((String)contractCode)) {
            return new JSONArray();
        }
        List<SaleGoalVo> saleGoalVos = this.saleGoalService.findDetailsByContractCodeAndIndexCode(contractCode, indexCode);
        return new JSONArray((List)BeanCopyUtil.formatJSONArray(saleGoalVos));
    }

    private void buildBaseInfo(SaleGoalVo vo, SaleContractVo saleContractVo) {
        if (vo != null && saleContractVo != null) {
            vo.setObjectType(SaleGoalEunm.ObjectType.CUSTOMER.getCode());
            vo.setCusCode(saleContractVo.getCusCode());
            vo.setCusName(saleContractVo.getCusName());
            vo.setCusChannelCode(saleContractVo.getChannelCode());
            vo.setCusChannelName(saleContractVo.getChannelName());
            vo.setCusOrgCode(saleContractVo.getOrgCode());
            vo.setCusOrgName(saleContractVo.getOrgName());
        }
    }
}

