/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function.impl.fullreduce;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.AbstractCalculateRuleFunction;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.CommonConstant;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

@Component(value="calculateLadderLoopReduce")
public class CalculateLadderLoopReduce
extends AbstractCalculateRuleFunction<CalculateRuleParam, CalculateRuleResponse> {
    @Override
    public CalculateRuleResponse apply(CalculateRuleParam calculateRuleParam) {
        RuleFunction ruleFunction;
        try {
            ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(calculateRuleParam.getConditionRuleFunctionBeanName(), RuleFunction.class);
        }
        catch (BeansException e) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u6761\u4ef6\u89c4\u5219[" + calculateRuleParam.getConditionRuleFunctionBeanName() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
        }
        String resultDataType = null;
        String resultDataUnitType = null;
        BigDecimal result = null;
        List<PromotionRuleEditVo.ControlRow> ladderList = calculateRuleParam.getLadderList();
        PromotionRuleEditVo.ControlRow tempLadder = null;
        for (int i = ladderList.size() - 1; i >= 0; --i) {
            BigDecimal computeResult;
            tempLadder = ladderList.get(i);
            ConditionRuleParam conditionRuleParam = new ConditionRuleParam();
            conditionRuleParam.setLadder(tempLadder);
            conditionRuleParam.setProductOrderBuy(calculateRuleParam.getProductOrderBuy());
            ConditionRuleResponse conditionRuleResponse = (ConditionRuleResponse)ruleFunction.apply(conditionRuleParam);
            BigDecimal remainder = conditionRuleResponse.getRemainder();
            if (conditionRuleResponse.getDivide().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal bigDecimal = computeResult = conditionRuleResponse.getGiftValue() == null ? BigDecimal.ZERO : conditionRuleResponse.getGiftValue();
            if (computeResult == null) continue;
            resultDataType = conditionRuleResponse.getResultDataType();
            resultDataUnitType = conditionRuleResponse.getResultDataUnitType();
            result = (result == null ? BigDecimal.ZERO : result).add(computeResult.multiply(conditionRuleResponse.getDivide()));
        }
        CalculateRuleResponse calculateRuleResponse = new CalculateRuleResponse();
        if (null == result) {
            calculateRuleResponse.setNoLadderMatchMsg("\u8d2d\u4e70\u91cf\u8fd8\u6ca1\u6709\u8fbe\u5230\u653f\u7b56\u9636\u68af\u8d77\u9001\u91cf!");
            calculateRuleResponse.setLadderUsed((List)Lists.newArrayList());
            return calculateRuleResponse;
        }
        if (CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(resultDataType)) {
            result = result == null ? result : result.setScale(0, 1);
        }
        calculateRuleResponse.setResultData(result);
        calculateRuleResponse.setResultDataType(resultDataType);
        calculateRuleResponse.setResultDataUnitType(resultDataUnitType);
        calculateRuleResponse.setLadderUsed((List)Lists.newArrayList((Object[])new PromotionRuleEditVo.ControlRow[]{tempLadder}));
        return calculateRuleResponse;
    }
}

