/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyRuleMapper;
import com.biz.crm.promotion.service.npromotion.PromotionRuleService;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"promotionRuleServiceExtend"})
public class PromotionRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyRuleMapper, PromotionPolicyRuleEntity>
implements PromotionRuleService {
    @Resource
    private PromotionPolicyRuleMapper promotionPolicyRuleMapper;

    @Override
    @Transactional
    public List<PromotionRuleVo> saveBatch(List<PromotionRuleVo> ruleVos, String promotionPolicyCode) {
        if (CollectionUtil.listEmpty(ruleVos)) {
            return Lists.newArrayList();
        }
        ruleVos.forEach(rule -> {
            if (rule.getControlRows() != null) {
                rule.setParams(JSONArray.toJSONString((Object)rule.getControlRows()));
            }
            if (RuleTypeDynamicEnum.CONDITION.getCode().equals(rule.getRuleType()) || RuleTypeDynamicEnum.LIMITED.getCode().equals(rule.getRuleType())) {
                ValidateUtils.validate((Object)rule.getParams(), (String)"\u6761\u4ef6\u3001\u9650\u91cf\u89c4\u5219\u5fc5\u987b\u4f20\u5165\u9636\u68af\u63a7\u4ef6");
                PromotionUtil.validateLadder(rule.getParams());
            }
        });
        List<PromotionRuleVo> oldRules = this.findByPromotionCode(promotionPolicyCode);
        List createRules = ruleVos.stream().filter(r -> StringUtils.isEmpty((String)r.getId())).collect(Collectors.toList());
        List createEntities = CrmBeanUtil.copyList(createRules, PromotionPolicyRuleEntity.class);
        this.saveBatch(createEntities);
        ruleVos.removeAll(createRules);
        ruleVos.addAll(CrmBeanUtil.copyList((List)createEntities, PromotionRuleVo.class));
        List updateRules = ruleVos.stream().filter(r -> StringUtils.isNotEmpty((String)r.getId())).collect(Collectors.toList());
        List updateEntities = CrmBeanUtil.copyList(updateRules, PromotionPolicyRuleEntity.class);
        this.updateBatchById(updateEntities);
        List deleteIds = CommonFieldUtil.difference(oldRules, ruleVos, (String[])new String[]{"id"});
        this.removeByIds(deleteIds);
        return ruleVos;
    }

    @Override
    public List<PromotionRuleVo> findByPromotionCode(String promotionPolicyCode) {
        if (StringUtils.isEmpty((String)promotionPolicyCode)) {
            return Lists.newArrayList();
        }
        List entities = this.promotionPolicyRuleMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(PromotionPolicyRuleEntity::getPromotionPolicyCode, (Object)promotionPolicyCode));
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        List vos = CrmBeanUtil.copyList((List)entities, PromotionRuleVo.class);
        vos.forEach(vo -> {
            if (StringUtils.isNotEmpty((String)vo.getParams())) {
                vo.setControlRows(JSONArray.parseArray((String)vo.getParams(), PromotionRuleEditVo.ControlRow.class));
            }
        });
        return vos;
    }
}

