/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.util;

import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisCacheUtil
implements ApplicationContextAware {
    private static final int CACHE_MAX_DAYS = 30;
    private static RedisService redisService;
    private static RedisTemplate redisTemplate;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        redisService = (RedisService)applicationContext.getBean(RedisService.class);
        redisTemplate = (RedisTemplate)applicationContext.getBean("redisTemplate", RedisTemplate.class);
        PromotionUtil.applicationContext = applicationContext;
    }

    protected static <T> T get(String key) {
        Object t = redisService.get(key);
        return (T)t;
    }

    protected static <T> List<T> multiGet(List<String> keys) {
        List list = redisTemplate.opsForValue().multiGet(keys);
        return list;
    }

    protected static void setByDays(String key, Object value) {
        redisService.setDays(key, value, 30L);
    }

    protected static void set(String key, Object value) {
        redisService.setDays(key, value, 30L);
    }

    protected static void delete(List<String> keys) {
        if (CollectionUtil.listEmpty(keys)) {
            return;
        }
        redisService.del(keys.toArray(new String[keys.size()]));
    }
}

