package com.biz.crm;


import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;

import java.net.InetAddress;
import java.net.UnknownHostException;

@SpringBootApplication
@EnableEurekaClient
@EnableFeignClients
@EnableAsync
//@MapperScan(value={"com.biz.crm.**.mapper*"})
@Slf4j
public class ExcelApplication {
  public static void main(String[] args) throws UnknownHostException {
    System.setProperty("es.set.netty.runtime.available.processors", "false");
    ConfigurableApplicationContext application = SpringApplication.run(ExcelApplication.class, args);
    Environment env = application.getEnvironment();
    String ip = InetAddress.getLocalHost().getHostAddress();
    String port = env.getProperty("server.port");
    String path = env.getProperty("server.servlet.context-path");
    log.info("\n----------------------------------------------------------\n\t" +
            "Application crm-excel is running! Access URLs:\n\t" +
            "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
//            "外部访问地址: \thttp://" + ip + ":" + port + path + "/\n\t" +
            "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
            "----------------------------------------------------------");
  }
}
