package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.DmsDruidParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;


/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/30 下午7:53
 */
@Configuration
@Slf4j
@MapperScan(value={"com.biz.crm.dms.**.mapper*"},sqlSessionTemplateRef = "dmsSqlSessionTemplate")
public class DmsDruidConfig {
    @Resource
    private DmsDruidParam dmsDruidParam ;
    @Bean("dmsDataSource")
    public DataSource dmsDataSource () {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(dmsDruidParam.getDbUrl());
        datasource.setUsername(dmsDruidParam.getUsername());
        datasource.setPassword(dmsDruidParam.getPassword());
        datasource.setDriverClassName(dmsDruidParam.getDriverClassName());
        datasource.setInitialSize(dmsDruidParam.getInitialSize());
        datasource.setMinIdle(dmsDruidParam.getMinIdle());
        datasource.setMaxActive(dmsDruidParam.getMaxActive());
        datasource.setMaxWait(dmsDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(dmsDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(dmsDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(dmsDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(dmsDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(dmsDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(dmsDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(dmsDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(dmsDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(dmsDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(dmsDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(dmsDruidParam.getConnectionProperties());
        return datasource;
    }
    @Bean
    public SqlSessionFactory dmsSqlSessionFactory() throws Exception{
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(dmsDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/dms/**/*.xml"));
        GlobalConfig globalConfig=new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor() );
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }
    @Bean(name="dmsTransactionManager")
    @Primary
    public DataSourceTransactionManager dmsTransactionManager(){
        return  new DataSourceTransactionManager(dmsDataSource());
    }
    @Primary
    @Bean(name = "dmsSqlSessionTemplate")
    public SqlSessionTemplate dmsSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(dmsSqlSessionFactory());
    }
}
