package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.ExcelDruidParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/30 下午7:53
 */
@Configuration
@Slf4j
@MapperScan(basePackages = {"com.biz.crm.excel.**.mapper*"},sqlSessionTemplateRef = "excelSqlSessionTemplate")
public class ExcelDruidConfig {
    @Resource
    private ExcelDruidParam excelDruidParam ;
    @Bean("excelDataSource")
    public DataSource excelDataSource () {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(excelDruidParam.getDbUrl());
        datasource.setUsername(excelDruidParam.getUsername());
        datasource.setPassword(excelDruidParam.getPassword());
        datasource.setDriverClassName(excelDruidParam.getDriverClassName());
        datasource.setInitialSize(excelDruidParam.getInitialSize());
        datasource.setMinIdle(excelDruidParam.getMinIdle());
        datasource.setMaxActive(excelDruidParam.getMaxActive());
        datasource.setMaxWait(excelDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(excelDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(excelDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(excelDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(excelDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(excelDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(excelDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(excelDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(excelDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(excelDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(excelDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(excelDruidParam.getConnectionProperties());
        return datasource;
    }
    @Bean
    @Primary
    public SqlSessionFactory excelSqlSessionFactory() throws Exception{
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
//        factory.setTypeAliasesPackage("com.biz.crm.excel.demo.entity");
        factory.setDataSource(excelDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/excel/**/*.xml"));
        GlobalConfig globalConfig=new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor() );
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }
    @Bean(name="excelTransactionManager")
    public DataSourceTransactionManager excelTransactionManager(){
        return  new DataSourceTransactionManager(excelDataSource());
    }
    @Bean(name = "excelSqlSessionTemplate")
    public SqlSessionTemplate excelSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(excelSqlSessionFactory());
    }
}
