package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.FeeDruidParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;


/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/30 下午7:53
 */
@Configuration
@Slf4j
@MapperScan(value = {"com.biz.crm.fee.**.mapper*"}, sqlSessionTemplateRef = "feeSqlSessionTemplate")
public class FeeDruidConfig {
    @Resource
    private FeeDruidParam feeDruidParam;

    @Bean("feeDataSource")
    public DataSource feeDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(feeDruidParam.getDbUrl());
        datasource.setUsername(feeDruidParam.getUsername());
        datasource.setPassword(feeDruidParam.getPassword());
        datasource.setDriverClassName(feeDruidParam.getDriverClassName());
        datasource.setInitialSize(feeDruidParam.getInitialSize());
        datasource.setMinIdle(feeDruidParam.getMinIdle());
        datasource.setMaxActive(feeDruidParam.getMaxActive());
        datasource.setMaxWait(feeDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(feeDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(feeDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(feeDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(feeDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(feeDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(feeDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(feeDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(feeDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(feeDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(feeDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(feeDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory feeSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(feeDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/fee/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name = "feeTransactionManager")
    @Primary
    public DataSourceTransactionManager feeTransactionManager() {
        return new DataSourceTransactionManager(feeDataSource());
    }

    @Primary
    @Bean(name = "feeSqlSessionTemplate")
    public SqlSessionTemplate feeSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(feeSqlSessionFactory());
    }
}
