package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.KmsDruidParam;
import com.biz.crm.interceptor.DataPermissionInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;

/**
 * @author maoshen
 * @date 2021/4/27.
 */
@Configuration
@Slf4j
@MapperScan(value = {"com.biz.crm.kms.**.mapper*"}, sqlSessionTemplateRef = "kmsSqlSessionTemplate")
public class KmsDruidConfig {

    @Resource
    private KmsDruidParam kmsDruidParam;

    @Resource
    private PaginationInterceptor paginationInterceptor;

    @Resource
    private DataPermissionInterceptor dataPermissionInterceptor;

    @Bean("kmsDataSource")
    public DataSource kmsDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(kmsDruidParam.getDbUrl());
        datasource.setUsername(kmsDruidParam.getUsername());
        datasource.setPassword(kmsDruidParam.getPassword());
        datasource.setDriverClassName(kmsDruidParam.getDriverClassName());
        datasource.setInitialSize(kmsDruidParam.getInitialSize());
        datasource.setMinIdle(kmsDruidParam.getMinIdle());
        datasource.setMaxActive(kmsDruidParam.getMaxActive());
        datasource.setMaxWait(kmsDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(kmsDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(kmsDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(kmsDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(kmsDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(kmsDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(kmsDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(kmsDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(kmsDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(kmsDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(kmsDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(kmsDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory kmsSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(kmsDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/kms/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        Interceptor[] interceptors = {paginationInterceptor,dataPermissionInterceptor};
        factory.setPlugins(interceptors);
        return factory.getObject();
    }

    @Bean(name = "kmsTransactionManager")
    @Primary
    public DataSourceTransactionManager mdmTransactionManager() {
        return new DataSourceTransactionManager(kmsDataSource());
    }

    @Primary
    @Bean(name = "kmsSqlSessionTemplate")
    public SqlSessionTemplate mdmSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(kmsSqlSessionFactory());
    }
}
