package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.MdmDruidParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;


/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/30 下午7:53
 */
@Configuration
@Slf4j
@MapperScan(value={"com.biz.crm.mdm.**.mapper*"},sqlSessionTemplateRef = "mdmSqlSessionTemplate")
public class MdmDruidConfig {
    @Resource
    private MdmDruidParam mdmDruidParam ;
    @Bean("mdmDataSource")
    public DataSource mdmDataSource () {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(mdmDruidParam.getDbUrl());
        datasource.setUsername(mdmDruidParam.getUsername());
        datasource.setPassword(mdmDruidParam.getPassword());
        datasource.setDriverClassName(mdmDruidParam.getDriverClassName());
        datasource.setInitialSize(mdmDruidParam.getInitialSize());
        datasource.setMinIdle(mdmDruidParam.getMinIdle());
        datasource.setMaxActive(mdmDruidParam.getMaxActive());
        datasource.setMaxWait(mdmDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(mdmDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(mdmDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(mdmDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(mdmDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(mdmDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(mdmDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(mdmDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(mdmDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(mdmDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(mdmDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(mdmDruidParam.getConnectionProperties());
        return datasource;
    }
    @Bean
    public SqlSessionFactory mdmSqlSessionFactory() throws Exception{
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(mdmDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/mdm/**/*.xml"));
        GlobalConfig globalConfig=new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor() );
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }
    @Bean(name="mdmTransactionManager")
    @Primary
    public DataSourceTransactionManager mdmTransactionManager(){
        return  new DataSourceTransactionManager(mdmDataSource());
    }
    @Primary
    @Bean(name = "mdmSqlSessionTemplate")
    public SqlSessionTemplate mdmSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(mdmSqlSessionFactory());
    }
}
