package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.SfaDruidParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;


/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/30 下午7:53
 */
@Configuration
@Slf4j
@MapperScan(value={"com.biz.crm.sfa.**.mapper*"},sqlSessionTemplateRef = "sfaSqlSessionTemplate")
public class SfaDruidConfig {
    @Resource
    private SfaDruidParam sfaDruidParam ;
    @Bean("sfaDataSource")
    public DataSource sfaDataSource () {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(sfaDruidParam.getDbUrl());
        datasource.setUsername(sfaDruidParam.getUsername());
        datasource.setPassword(sfaDruidParam.getPassword());
        datasource.setDriverClassName(sfaDruidParam.getDriverClassName());
        datasource.setInitialSize(sfaDruidParam.getInitialSize());
        datasource.setMinIdle(sfaDruidParam.getMinIdle());
        datasource.setMaxActive(sfaDruidParam.getMaxActive());
        datasource.setMaxWait(sfaDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(sfaDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(sfaDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(sfaDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(sfaDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(sfaDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(sfaDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(sfaDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(sfaDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(sfaDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(sfaDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(sfaDruidParam.getConnectionProperties());
        return datasource;
    }
    @Bean
    public SqlSessionFactory sfaSqlSessionFactory() throws Exception{
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(sfaDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/sfa/**/*.xml"));
        GlobalConfig globalConfig=new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor() );
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }
    @Bean(name="sfaTransactionManager")
    @Primary
    public DataSourceTransactionManager sfaTransactionManager(){
        return  new DataSourceTransactionManager(sfaDataSource());
    }
    @Primary
    @Bean(name = "sfaSqlSessionTemplate")
    public SqlSessionTemplate sfaSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(sfaSqlSessionFactory());
    }


}
