package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.data.TpmDruidParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.annotation.Resource;
import javax.sql.DataSource;


/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/11/30 下午7:53
 */
@Configuration
@Slf4j
@MapperScan(value={"com.biz.crm.tpm.**.mapper*"},sqlSessionTemplateRef = "tpmSqlSessionTemplate")
public class TpmDruidConfig {
    @Resource
    private TpmDruidParam tpmDruidParam ;
    @Bean("tpmDataSource")
    public DataSource tpmDataSource () {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(tpmDruidParam.getDbUrl());
        datasource.setUsername(tpmDruidParam.getUsername());
        datasource.setPassword(tpmDruidParam.getPassword());
        datasource.setDriverClassName(tpmDruidParam.getDriverClassName());
        datasource.setInitialSize(tpmDruidParam.getInitialSize());
        datasource.setMinIdle(tpmDruidParam.getMinIdle());
        datasource.setMaxActive(tpmDruidParam.getMaxActive());
        datasource.setMaxWait(tpmDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis(tpmDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis(tpmDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis(tpmDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(tpmDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(tpmDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(tpmDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(tpmDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(tpmDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(tpmDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(tpmDruidParam.getFilters());
        } catch (Exception e) {
            log.error("druid configuration initialization filter", e);
        }
        datasource.setConnectionProperties(tpmDruidParam.getConnectionProperties());
        return datasource;
    }
    @Bean
    public SqlSessionFactory tpmSqlSessionFactory() throws Exception{
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(tpmDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/tpm/**/*.xml"));
        GlobalConfig globalConfig=new GlobalConfig();
        globalConfig.setMetaObjectHandler(new OperatorInterceptor() );
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }
    @Bean(name="tpmTransactionManager")
    @Primary
    public DataSourceTransactionManager tpmTransactionManager(){
        return  new DataSourceTransactionManager(tpmDataSource());
    }
    @Primary
    @Bean(name = "tpmSqlSessionTemplate")
    public SqlSessionTemplate tpmSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(tpmSqlSessionFactory());
    }
}
