package com.biz.crm.excel.component;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.util.ExcelImportUtil;
import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;


/**
 *  @author: luoqi
 *  @Date: 2021-1-5 14:58
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public abstract class AbstractImportHelper<M extends BaseMapper<T>, T> extends ServiceImpl<M, T> {
    //MQ服务
    @Resource
    private RocketMQProducer rocketMQProducer;
    /**
     * 发送 WebsocketMsg
     * @param msg
     * @param context
     */
    protected void sendWebsocketMsgMQ(String msg, DefaultImportContext context){
        String webSocketClientId = context.getImportParamVo().getWebSocketClientId();
        if(StringUtils.isBlank(webSocketClientId)){
            if(log.isInfoEnabled()){
                log.info("未提交 websocket id，忽略 websocket 消息发送！");
            }
            return;
        }
        MqMessageParam mqMessageParam = new MqMessageParam();
        mqMessageParam.setClientId(webSocketClientId);
        mqMessageParam.setMsg(ExcelImportUtil.importSocketMsgGenerate(msg));
        //MQ消息体
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        mqMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.EXCEL_IMPORT_WEBSOCKET_MSG);
        mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(mqMessageParam));
        this.rocketMQProducer.convertAndSend(mqMessageBody);
    }
}
