package com.biz.crm.excel.component.export.extend.head;


import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 导出列头扩展, 实现类必须以 @Component 注解管理起来。
 * 且 bean name 必须以 功能编码 functionCode + ExportHeadExtend.beanNameAsSuffix 命名（参照 MonthSignExportHeadExtend）
 *  @author: luoqi
 *  @Date: 2021-1-29 19:46
 *  @version: V1.0
 *  @Description:
 */
public interface ExportHeadExtend {
    /**
     * 实现类bean name后缀
     */
    String beanNameAsSuffix = "ExportHeadExtend";
    /**
     * 扩展处理
     * @param headExtendParam
     * @throws BusinessException
     */
    List<MdmColumnExportRespVo> getHeads(ExportHeadExtendParam headExtendParam) throws BusinessException;

    /**
     * 扩展处理
     * @param exportContext
     * @param value
     * @return
     */
    default List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        return value;
    }

    @Data
    class ExportHeadExtendParam {
        /**
         * 查询出来的数据行
         */
        private Map dataRow;
        /**
         * 导出列头扩展数量
         */
        private Integer headVariableSum;
    }
}
