package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.sfa.helpdefense.SfaHelpDefenseDto;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitAssitPlanFeign;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 协访计划报表导出表头扩展
 * @author yangshan
 */
@Slf4j
@Component("sfa_interview_plan" + ExportHeadExtend.beanNameAsSuffix)
public class HelpDefenseExportHeadExtend implements ExportHeadExtend {
    private static final String ID = "id";
    private static final String CLIENT_CODE = "clientCode";
    private static final String CLIENT_NAME = "终端";
    private static final String REAL_NAME = "realName";
    private static final String NAME = "被协访人员姓名";

    @Resource
    private SfaVisitAssitPlanFeign sfaVisitAssitPlanFeign;

    /**
     * 扩展处理
     *
     * @param headExtendParam
     * @throws BusinessException
     */
    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtendParam headExtendParam) throws BusinessException {
        Integer headVariableSum = headExtendParam.getHeadVariableSum();
        List<MdmColumnExportRespVo> columnExportRespVos = Lists.newArrayList();

        //组装表头字段
        this.buildColumn(headVariableSum, columnExportRespVos);
        return columnExportRespVos;
    }

    /**
     * 构建表头
     * @param headVariableSum
     * @param columnExportRespVos
     */
    private void buildColumn(Integer headVariableSum, List<MdmColumnExportRespVo> columnExportRespVos) {
        //执行人
        MdmColumnExportRespVo columnExportRespVo1 = new MdmColumnExportRespVo();
        columnExportRespVo1.setField(HelpDefenseExportHeadExtend.REAL_NAME);
        columnExportRespVo1.setTitle(HelpDefenseExportHeadExtend.NAME);
        columnExportRespVos.add(columnExportRespVo1);
        //终端
        for (int i = 1; i <= headVariableSum; i++){
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(HelpDefenseExportHeadExtend.CLIENT_CODE+i);
            columnExportRespVo.setTitle(HelpDefenseExportHeadExtend.CLIENT_NAME+i);
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    /**
     *
     * @param idList
     * @return
     */
    private Map<String, List<SfaHelpDefenseDto>> getDate(List<String> idList) {
        List<SfaHelpDefenseRespVo> sfaHelpDefenseRespVos = ApiResultUtil.objResult(sfaVisitAssitPlanFeign.queryListById(idList), true);
        if (CollectionUtil.listEmpty(sfaHelpDefenseRespVos)){
            return Maps.newHashMap();
        }
        //协防客户信息列表
        Map<String, List<SfaHelpDefenseDto>> result = sfaHelpDefenseRespVos.stream().collect(Collectors.toMap(SfaHelpDefenseRespVo::getId, SfaHelpDefenseRespVo::getSfaHelpDefenseList));
        return result;
    }

    /**
     * 取出协防客户信息列表，取出被协访人列表，迭代取出对应的终端列表
     * 构建行数据为 基础数据+被协访人1+终端1+终端2
     * @param exportContext
     * @param value
     * @return
     */
    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        List<String> idList = value.stream().map(map -> (String)map.get(HelpDefenseExportHeadExtend.ID)).collect(Collectors.toList());
        List<Map> objects = Lists.newArrayList();
        if (CollectionUtil.listNotEmpty(value)){
            Map<String, List<SfaHelpDefenseDto>> date = this.getDate(idList);
            value.forEach(v -> {
                //根据id取协防客户信息列表
                String id = (String)v.get(HelpDefenseExportHeadExtend.ID);
                List<SfaHelpDefenseDto> sfaHelpDefenseDtos = date.get(id);
                if (CollectionUtil.listEmpty(sfaHelpDefenseDtos)){
                    objects.add(v);
                }
                //迭代列表，构建每个人对应的终端
                sfaHelpDefenseDtos.forEach(s -> {
                    Map<String, String> map = Maps.newHashMap();
                    map.putAll(v);
                    String coverHelpRealName = s.getCoverHelpRealName();
                    if (StringUtils.isNotEmpty(coverHelpRealName)){
                        map.put(HelpDefenseExportHeadExtend.REAL_NAME, coverHelpRealName);
                        List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailList = s.getSfaHelpDefenseDetailList();
                        if (CollectionUtil.listNotEmpty(sfaHelpDefenseDetailList)){
                            List<String> clientNames = sfaHelpDefenseDetailList.stream().map(SfaHelpDefenseDetailRespVo::getClientName).collect(Collectors.toList());
                            //更新表头扩展数量
                            if (clientNames.size() > exportContext.getHeadVariableSum()){
                                exportContext.setHeadVariableSum(clientNames.size());
                            }
                            //扩展终端
                            for (int i = 1; i <= clientNames.size(); i++){
                                map.put(HelpDefenseExportHeadExtend.CLIENT_CODE + i, clientNames.get(i-1));
                            }
                        }
                    }
                    objects.add(map);
                });
            });
        }
        return objects;
    }

}
