package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;


/**
 * 月度考勤报表导出表头扩展
 *  @author: luoqi
 *  @Date: 2021-1-30 22:27
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component("sfa_attendance_monthly_attendance" + ExportHeadExtend.beanNameAsSuffix)
public class MonthSignExportHeadExtend implements ExportHeadExtend {
    private static final String day = "day";
    private static final String month = "month";
    private static final String year = "year";

    /**
     * 扩展处理
     *
     * @param headExtendParam
     * @throws BusinessException
     */
    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtendParam headExtendParam) throws BusinessException {
        Map dataRow = headExtendParam.getDataRow();
        List<MdmColumnExportRespVo> columnExportRespVos = Lists.newArrayList();
        LocalDate date = this.getDate(dataRow);
        int dayOfMonth;
        if(null == date){
            //转换日期失败，默认导出最大列
            dayOfMonth = 31;
            this.buildColumn(dayOfMonth, columnExportRespVos);
            return columnExportRespVos;
        }
        LocalDate now = LocalDate.now();

        if(now.getYear() == date.getYear() && now.getMonthValue() == date.getMonthValue()){
            //当月，取当天
            dayOfMonth = now.getDayOfMonth();
        }else {
            //其他月份
            dayOfMonth = date.getMonth().maxLength();
        }
        //组装表头字段
        this.buildColumn(dayOfMonth, columnExportRespVos);
        return columnExportRespVos;
    }

    private void buildColumn(final int dayOfMonth, List<MdmColumnExportRespVo> columnExportRespVos){
        for (int i = 1; i <= dayOfMonth; i++){
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(day + i);
            columnExportRespVo.setTitle(String.valueOf(i));
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    /**
     *
     * @param dataRow
     * @return
     */
    private LocalDate getDate(Map dataRow){
        try {
            String year = (String)(dataRow.get(MonthSignExportHeadExtend.year));
            String month = (String)(dataRow.get(MonthSignExportHeadExtend.month));
            if(month.length() == 1){
                month = "0" + month;
            }
            month = month + "-01";
            return LocalDate.parse(year + "-" + month);
        }catch (Exception e){
            log.error("没有年月数据", e);
            return null;
        }

    }
}
