package com.biz.crm.excel.component.export.extend.head.sfa;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.excel.vo.sfa.StockDetailVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import java.util.List;
import java.util.Map;

/**
 * @author yangshan
 * @date 2021/6/11 17:22
 */
@Slf4j
@Component("sfaCenter_visitManage_inventoryDetail_detailForm_export" + ExportHeadExtend.beanNameAsSuffix)
public class StockInventoryHeadExtend implements ExportHeadExtend {
    private static String PRODUCT_CODE = "productCode";
    private static String PRODUCT_NAME = "productName";
    private static String PRODUCT_LEVEL_CODE = "productLevelCode";
    private static String PRODUCT_LEVEL_NAME = "productLevelName";
    private static String QUANTITY = "quantity";
    private static String SALE_UNIT_NAME = "saleUnitName";
    private static String ext1 = "ext1";
    private static String ext2 = "ext2";
    private static String ext3 = "ext3";
    private static String ext4 = "ext4";
    private static String ext5 = "ext5";
    private static String ext6 = "ext6";
    private static String ext7 = "ext7";
    private static String ext8 = "ext8";
    private static String ext9 = "ext9";
    private static String ext10 = "ext10";

    /**
     * 扩展处理
     *
     * @param headExtendParam
     * @throws BusinessException
     */
    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtendParam headExtendParam) throws BusinessException {
        return null;
    }

    /**
     * 扩展处理
     * 库存盘点明细,一种商品一条记录
     * @param exportContext
     * @param value
     * @return
     */
    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        List<Map> result = Lists.newArrayList();
        value.forEach(v -> {
            List<StockDetailVo> visitStepStockList = (List<StockDetailVo>) v.get("visitStepStockList");
            if (CollectionUtil.listNotEmpty(visitStepStockList)){
                for (int i=0; i<visitStepStockList.size(); i++) {
                    Map<String, String> map = Maps.newHashMap();
                    map.putAll(v);
                    StockDetailVo stockDetailVo = JSON.parseObject(JSON.toJSONString(visitStepStockList.get(i)), StockDetailVo.class);
                    if (null == stockDetailVo) {
                        continue;
                    }
                    this.setValue(map, stockDetailVo);
                    result.add(map);
                }
            }
        });
        return result;
    }

    /**
     * 若要导出扩展字段需后台sfaCenter_visitManage_inventoryDetail_detailForm_export添加字段
     * @param map
     * @param stockDetailVo
     */
    private void setValue(Map<String, String> map, StockDetailVo stockDetailVo){
        map.put(StockInventoryHeadExtend.PRODUCT_LEVEL_CODE, stockDetailVo.getProductLevelCode());
        map.put(StockInventoryHeadExtend.PRODUCT_LEVEL_NAME, stockDetailVo.getProductLevelName());
        map.put(StockInventoryHeadExtend.PRODUCT_CODE, stockDetailVo.getProductCode());
        map.put(StockInventoryHeadExtend.PRODUCT_NAME, stockDetailVo.getProductName());
        map.put(StockInventoryHeadExtend.QUANTITY, stockDetailVo.getQuantity().toString());
        map.put(StockInventoryHeadExtend.SALE_UNIT_NAME, stockDetailVo.getSaleUnitName());

        //扩展字段
        map.put(StockInventoryHeadExtend.ext1, stockDetailVo.getExt1());
        map.put(StockInventoryHeadExtend.ext2, stockDetailVo.getExt2());
        map.put(StockInventoryHeadExtend.ext3, stockDetailVo.getExt3());
        map.put(StockInventoryHeadExtend.ext4, stockDetailVo.getExt4());
        map.put(StockInventoryHeadExtend.ext5, stockDetailVo.getExt5());
        map.put(StockInventoryHeadExtend.ext6, stockDetailVo.getExt6());
        map.put(StockInventoryHeadExtend.ext7, stockDetailVo.getExt7());
        map.put(StockInventoryHeadExtend.ext8, stockDetailVo.getExt8());
        map.put(StockInventoryHeadExtend.ext9, stockDetailVo.getExt9());
        map.put(StockInventoryHeadExtend.ext10, stockDetailVo.getExt10());
    }
}
