package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepTpmActivityFeign;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yangshan
 * @date 2021/6/18 14:00
 */
@Slf4j
@Component("sfaCenter_activityActivityReport_tpmExecuteReport_list" + ExportHeadExtend.beanNameAsSuffix)
public class TpmActCollectDetailExportHeadExtend implements ExportHeadExtend {
    private static final String ID = "id";
    private static final String PHOTO = "photo";
    private static final String PHOTO_TITLE = "照片";
    @Resource
    private SfaVisitStepTpmActivityFeign sfaVisitStepTpmActivityFeign;

    /**
     * 扩展处理
     *
     * @param headExtendParam
     * @throws BusinessException
     */
    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtendParam headExtendParam) throws BusinessException {
        Integer headVariableSum = headExtendParam.getHeadVariableSum();
        List<MdmColumnExportRespVo> columnExportRespVos = Lists.newArrayList();

        //组装表头字段
        this.buildColumn(headVariableSum, columnExportRespVos);
        return columnExportRespVos;
    }

    /**
     * 构建表头
     * @param headVariableSum
     * @param columnExportRespVos
     */
    private void buildColumn(Integer headVariableSum, List<MdmColumnExportRespVo> columnExportRespVos) {
        for (int i = 1; i <= headVariableSum; i++){
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(PHOTO + (i-1));
            columnExportRespVo.setTitle(PHOTO_TITLE + i);
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    /**
     * 扩展处理
     *
     * @param exportContext
     * @param value
     * @return
     */
    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        value.forEach(m -> {
            Integer headVariableSum = exportContext.getHeadVariableSum();
            String id = (String) m.get(TpmActCollectDetailExportHeadExtend.ID);
            SfaTpmActTableRespVo respVo = ApiResultUtil.objResult(this.sfaVisitStepTpmActivityFeign.loadTpmActCollectDetailTableById(id), true);
            if (null == respVo){
                return;
            }
            List<SfaTpmActCollectVo.CollectForm> collectFormList = respVo.getCollectFormList();

            //扩展表头数量
            long count = collectFormList.stream().mapToInt(s -> s.getAttachmentList().size()).sum();
            if (count > headVariableSum){
                exportContext.setHeadVariableSum((int) count);
            }
            //图片
            collectFormList.forEach(form -> {
//                照片类型名称
//                String exampleName = form.getExampleName();
//                m.put("名称"+i, exampleName);
                List<AttachmentVo> attachmentList = form.getAttachmentList();
                if (null == attachmentList){
                    return;
                }
                List<String> urlList = attachmentList.stream().map(AttachmentVo::getUrl).collect(Collectors.toList());
                for (int i=0; i<urlList.size(); i++){
                    m.put(PHOTO + i, urlList.get(i));
                }
            });
        });

        return value;
    }
}
