package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import java.util.List;
import java.util.Map;


/**
 * 线路组导出表头扩展
 *
 * @author: luoqi
 * @Date: 2021-1-30 22:27
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component("line_group_management" + ExportHeadExtend.beanNameAsSuffix)
public class VisitGroupListExportHeadExtend implements ExportHeadExtend {
    private static final String CLIENT_NAME = "终端";
    private static final String CLIENT_CODE = "clientCode";
    private static final String CLIENT_NAMES = "clientNames";

    /**
     * 扩展处理
     *
     * @param headExtendParam
     * @throws BusinessException
     */
    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtendParam headExtendParam) throws BusinessException {
        Integer headVariableSum = headExtendParam.getHeadVariableSum();
        List<MdmColumnExportRespVo> columnExportRespVos = Lists.newArrayList();

        //组装表头字段
        this.buildColumn(headVariableSum, columnExportRespVos);
        return columnExportRespVos;
    }

    /**
     * 按照数量动态扩展表头
     * @param headVariableSum
     * @param columnExportRespVos
     */
    private void buildColumn(Integer headVariableSum, List<MdmColumnExportRespVo> columnExportRespVos) {
        for (int i = 1; i <= headVariableSum; i++){
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(VisitGroupListExportHeadExtend.CLIENT_CODE + i);
            columnExportRespVo.setTitle(VisitGroupListExportHeadExtend.CLIENT_NAME + i);
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        if (CollectionUtil.listNotEmpty(value)){
            value.forEach(v -> this.buildDate(exportContext, v));
        }
        return value;
    }

    /**
     * 将每一行中终端名字符串切割成Array，构建每一行的数据
     * @param exportContext
     * @param dataRow
     * @return
     */
    private Map buildDate(DefaultExportContext exportContext, Map dataRow) {
        String clientNames = (String)dataRow.get(VisitGroupListExportHeadExtend.CLIENT_NAMES);
        String[] clientName = clientNames.split(",");
        //分页更新表头扩展数量
        if (clientName.length > exportContext.getHeadVariableSum()){
            exportContext.setHeadVariableSum(clientName.length);
        }
        for (int i = 0; i < clientName.length; i++){
            dataRow.put(VisitGroupListExportHeadExtend.CLIENT_CODE + (i+1), clientName[i]);
        }
        return dataRow;
    }
}
