package com.biz.crm.excel.component.helper;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.excel.vo.MdmPropertyImportVo;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 16:18
 * @description
 */
@Service
public class MdmPropertyCheckHelper {

    @Resource
    private MdmOrgFeign orgFeign;

    @Resource
    private MdmCustomerMsgFeign customerFeign;

    @Resource
    private MdmTerminalFeign terminalFeign;

    public Map<String , MdmOrgRespVo> getOrgMapByOrgCode(String orgCode){
        //查询当前登录人所属组织及包含的下级组织信息
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(orgCode);
        return ApiResultUtil.objResult(orgFeign.findAllChildrenOrgList(mdmOrgReqVo), true)
                .stream()
                .collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, mdmOrgRespVo -> mdmOrgRespVo));
    }

    public Map<String, MdmCustomerMsgRespVo> getCustomerMapByOrgCodes(List<String> orgCodeList){
        MdmCustomerAndOrgReqVo reqVo = new MdmCustomerAndOrgReqVo();
        reqVo.setOrgCodeList(orgCodeList);
        return ApiResultUtil.objResult(customerFeign.findSubCustomerList(reqVo), true).stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, mdmCustomerMsgRespVo -> mdmCustomerMsgRespVo));
    }

    public Map<String, MdmTerminalVo> getTerminalMapByCustomerCodes (List<String> customerCodeList){
        MdmCustomerTerminalVo customerTerminalVo = new MdmCustomerTerminalVo();
        customerTerminalVo.setCustomerCodeList(Lists.newArrayList(customerCodeList));
        return ApiResultUtil.objResult(terminalFeign.customerTerminalList(customerTerminalVo), true)
                .stream()
                .collect(Collectors.toMap(MdmTerminalVo::getTerminalCode, mdmTerminalVo ->  mdmTerminalVo));
    }


    /**
     * 检查组织
     * @param data 数据源
     * @param orgCode 组织编码
     */
    public void checkOrg(MdmPropertyImportVo data, String orgCode, boolean notNull){
        if(StringUtils.isEmpty(data.getOrgCode())){
           if(notNull){
               data.appendErrorValidateMsg("组织编码不能为空;");
           }
        }else {
            MdmOrgRespVo orgRespVo;
            Map<String ,MdmOrgRespVo> mdmOrgRespVoMap = getOrgMapByOrgCode(orgCode);
            if((orgRespVo = mdmOrgRespVoMap.get(data.getOrgCode())) == null){
                data.appendErrorValidateMsg("所填组织编码不是当前及下级组织的组织编码;");
            }else {
                data.setOrgName(orgRespVo.getOrgName());
            }
        }
    }


    /**
     * 检查客户是否为组织下的客户
     * @param data 数据源
     * @param orgCode 客户信息
     */
    public void checkCustomer(MdmPropertyImportVo data, String orgCode, boolean notNull){
        if(StringUtils.isEmpty(data.getCustomerCode())){
            if(notNull){
                data.appendErrorValidateMsg("客户编码不能为空;");
            }
        }else {
            MdmCustomerMsgRespVo customerMsgRespVo;
            Map<String, MdmCustomerMsgRespVo> customerMsgRespVoMap = getCustomerMapByOrgCodes(Lists.newArrayList(orgCode));
            if((customerMsgRespVo = customerMsgRespVoMap.get(data.getCustomerCode())) == null){
                data.appendErrorValidateMsg("不是所填组织下的客户;");
            }else {
                data.setCustomerOrgCode(customerMsgRespVo.getCustomerOrgCode());
                data.setCustomerOrgName(customerMsgRespVo.getCustomerOrgName());
                data.setCustomerName(customerMsgRespVo.getCustomerName());
            }
        }
    }

    /**
     * 检查终端是否为客户关联终端
     * @param data 数据源
     */
    public void checkTerminal(MdmPropertyImportVo data, boolean notNull){
        if(StringUtils.isEmpty(data.getTerminalCode())){
            if(notNull){
                data.appendErrorValidateMsg("门店编码不能为空;");
            }
        }else {
            Map<String, MdmTerminalVo> terminalVoMap = getTerminalMapByCustomerCodes(Lists.newArrayList(data.getCustomerCode()));
            MdmTerminalVo terminalVo;
            if((terminalVo = terminalVoMap.get(data.getTerminalCode())) == null){
                data.appendErrorValidateMsg("所填门店编码不是所填客户关联终端;");
            }else {
                data.setTerminalName(terminalVo.getTerminalName());
            }
        }
    }
}
