package com.biz.crm.excel.component.saver.dms.order;

import com.biz.crm.dms.order.DmsOrderFeign;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderImportVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.util.CommonConstant;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 订单导入逻辑处理类
 * @Author: chenrong
 * @Date: 2021/3/23 14:05
 */
@Component("dmsOrderSaver")
public class DmsOrderSaver implements ExcelImportSaver<OrderImportVo> {

  //默认提货方式：配送
  private static final String DEFAULT_PICK_TYPE = "0";
  //默认订单来源：导入订单
  private static final String DEFAULT_ORDER_RESOURCE = "10";
  //单次保存订单条数
  private static final int SAVE_COUNT = 20;

  @Resource
  private DmsOrderFeign dmsOrderFeign;

  @Override
  public void save(List<OrderImportVo> list, DefaultImportContext defaultImportContext) {
    //导入标识：客户编码+送达方编码+订单类型+SAP物料编码+商品数量
    Map<String, List<OrderImportVo>> orderMap = list.stream().collect(Collectors.groupingBy(li ->
            String.join(",", li.getCusCode(), li.getPickAddressCode(), li.getOrderTypeCode(), li.getPickDate())));
    List<OrderVo> orderVos = Lists.newArrayList();
    orderMap.forEach((k, v) -> {
      //构建订单抬头
      OrderVo order = this.buildOrderHead(k, v.get(0));
      //构建订单明细
      List<OrderDetailVo> details = this.buildOrderDetails(v);
      List<OrderGroupItemVo> orderGroupItemVos = Lists.newArrayList();
      details.forEach(detail -> {
        OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
        groupItemVo.setNormalList(Lists.newArrayList(detail));
        groupItemVo.setGiftList(Lists.newArrayList());
        groupItemVo.setBackList(Lists.newArrayList());
        orderGroupItemVos.add(groupItemVo);
      });
      order.setGroupItemVos(orderGroupItemVos);
      orderVos.add(order);
      List<OrderVo> vos = Lists.newArrayList();
      for(int i =1; i <= orderVos.size(); i++) {
        vos.add(orderVos.get(i-1));
        if(i % SAVE_COUNT == 0 || i == orderVos.size()) {
//          dmsOrderFeign.saveImportOrders(vos);
          vos.clear();
        }
      }
    });

  }

  /**
   * 构建订单明细
   * @param orderImportVos
   * @return
   */
  private List<OrderDetailVo> buildOrderDetails(List<OrderImportVo> orderImportVos) {
    List<OrderDetailVo> details = Lists.newArrayList();
    int i = 0;
    for (OrderImportVo o : orderImportVos) {
      OrderDetailVo detail = new OrderDetailVo();
      detail.setProductCode(o.getProductCode());
      detail.setProductName(o.getProductName());
      detail.setProductNum(new BigDecimal(o.getCount()));
      detail.setLineNo(String.valueOf(i));
      detail.setPrice(o.getPrice());
      detail.setAmount(o.getAmount());
      details.add(detail);
      i ++;
    }
    return details;
  }

  /**
   * 构建订单抬头
   * @param k
   * @param orderImportVo
   * @return
   */
  private OrderVo buildOrderHead(String k, OrderImportVo orderImportVo) {
    OrderVo order = new OrderVo();
    String[] ks = k.split(",");
    order.setCusCode(ks[0]);
    order.setCusName(orderImportVo.getCusName());
    order.setPickAdress(ks[1]);
    order.setType(ks[2]);
    order.setPickType(DEFAULT_PICK_TYPE);
    order.setFromType(DEFAULT_ORDER_RESOURCE);
    order.setGiveDate(ks[3]);
    order.setRemarks(orderImportVo.getRemark());
    //默认暂存单
    order.setTemporaryFlag(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
    return order;
  }
}
