package com.biz.crm.excel.component.saver.dms.order;

import com.biz.crm.dms.order.DmsOrderFeign;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderImportVo;
import com.biz.crm.nebular.dms.order.OrderUpdateImportVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

import static com.biz.crm.eunm.dms.OrderEunm.LineTypeEnum.GIFT_PRODUCT;
import static com.biz.crm.eunm.dms.OrderEunm.LineTypeEnum.REP_PRODUCT;
import static com.biz.crm.eunm.dms.OrderEunm.LineTypeEnum.SOURCE_PRODUCT;

/**
 * @Author: chenrong
 * @Date: 2021/3/24 17:56
 */
@Component("orderUpdateSaver")
public class OrderUpdateSaver implements ExcelImportSaver<OrderUpdateImportVo> {

  //默认提货方式：配送
  private static final String DEFAULT_PICK_TYPE = "0";
  //单次保存订单条数
  private static final int SAVE_COUNT = 20;

  @Resource
  private DmsOrderFeign dmsOrderFeign;
  /**
   * 保存数据逻辑
   * 在一个事务内完成，要么都成功，要么都失败
   * @param data
   * @param context
   */
  @Override
  public void save(List<OrderUpdateImportVo> data, DefaultImportContext context) {
    //导入标识：订单编码
    Map<String, List<OrderUpdateImportVo>> orderMap = data.stream().collect(Collectors.groupingBy(OrderUpdateImportVo::getOrderCode));
    List<OrderVo> orderVos = Lists.newArrayList();
    orderMap.forEach((k, v) -> {
      //构建订单抬头
      OrderVo order = new OrderVo();
      order.setOrderCode(k);
      //构建订单明细
      List<OrderDetailVo> details = this.buildOrderDetails(v);
      List<OrderGroupItemVo> orderGroupItemVos = Lists.newArrayList();

      //构建本品（普通商品）
      details.forEach(detail -> {
        OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
        if(OrderEunm.LineTypeEnum.getByCode(detail.getProductCode()) == SOURCE_PRODUCT) {
          groupItemVo.setNormalList(Lists.newArrayList(detail));
        }
        //构建赠品，寻找该本品关联的赠品  TODO 暂时不考虑赠品
//        details.forEach(d -> {
//          if(OrderEunm.LineTypeEnum.getByCode(detail.getProductCode()) == GIFT_PRODUCT)
//        });
        orderGroupItemVos.add(groupItemVo);
      });
      //构建货补商品
      OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
      List<OrderDetailVo> backList = Lists.newArrayList();
      details.forEach(detail -> {
        if(OrderEunm.LineTypeEnum.getByCode(detail.getProductCode()) == REP_PRODUCT) {
          backList.add(detail);
        }
      });
      groupItemVo.setBackList(backList);
      orderGroupItemVos.add(groupItemVo);
      order.setGroupItemVos(orderGroupItemVos);
      orderVos.add(order);
      List<OrderVo> vos = Lists.newArrayList();
      for(int i =1; i <= orderVos.size(); i++) {
        vos.add(orderVos.get(i-1));
        if(i % SAVE_COUNT == 0 || i == orderVos.size()) {
//          dmsOrderFeign.updateImportOrders(vos);
          vos.clear();
        }
      }
    });
  }

  /**
   * 构建订单明细
   * @param orderImportVos
   * @return
   */
  private List<OrderDetailVo> buildOrderDetails(List<OrderUpdateImportVo> orderImportVos) {
    List<OrderDetailVo> details = Lists.newArrayList();
    int i = 0;
    for (OrderUpdateImportVo o : orderImportVos) {
      OrderDetailVo detail = new OrderDetailVo();
      detail.setProductCode(o.getProductCode());
      detail.setProductName(o.getProductName());
      detail.setProductNum(new BigDecimal(o.getCount()));
      detail.setLineNo(String.valueOf(i));
      detail.setPrice(o.getPrice());
      detail.setAmount(o.getAmount());
      detail.setId(o.getDetailId());
      detail.setLineType(o.getProductType());
      detail.setFeeCode(o.getFeeCode());
      detail.setFeeName(o.getFeeName());
      details.add(detail);
      i ++;
    }
    return details;
  }
}
