package com.biz.crm.excel.component.saver.kms.acceptance;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.acceptanceform.KmsAcceptanceFormImportVo;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.kms.form.acceptanceform.mapper.*;
import com.biz.crm.rawdata.model.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/28.
 */
@Slf4j
@Component("kmsAcceptanceFormImportSave")
@Transactional("kmsTransactionManager")
public class KmsAcceptanceFormImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsAcceptanceFormDetailDwMapper, KmsAcceptanceFormDetailDwEntity, KmsAcceptanceFormImportVo> implements ExcelImportSaver<KmsAcceptanceFormImportVo> {

    @Resource
    private KmsAcceptanceGoodsDetailDwMapper kmsAcceptanceGoodsDetailDwMapper;

    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    @Resource
    private KmsAcceptanceFormDetailDwMapper kmsAcceptanceFormDetailDwMapper;

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private KmsAcceptanceGoodsMapper kmsAcceptanceGoodsMapper;


    @Override
    public void save(List<KmsAcceptanceFormImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);
        Map<String, List<KmsAcceptanceFormImportVo>> dataMap = data.stream()
                .collect(Collectors.groupingBy(o -> o.getKaOrderNumber()));
        List<KmsDataAuthEntity> authEntities = Lists.newArrayList();
        List<KmsAcceptanceFormDetailDwEntity> detailDwEntities = Lists.newArrayList();
        List<KmsAcceptanceGoodsDetailDwEntity> goodsDetailDwEntities = Lists.newArrayList();
        dataMap.forEach((k, v) -> {
            // 权限
            KmsDataAuthEntity authEntity = new KmsDataAuthEntity();
            KmsAcceptanceFormDetailDwEntity formEntity = new KmsAcceptanceFormDetailDwEntity();
            for (int i = 0; i < v.size(); i++) {
                KmsAcceptanceFormImportVo importVo = v.get(i);
                //权限
                if (StringUtils.isEmpty(authEntity.getRespDataId())) {
                    authEntity.setRespDataId(UUIDGenerator.generate());
                    authEntity.setBsDirectSystemId(importVo.getBsDirectSystemId());
                    authEntities.add(authEntity);
                }
                //头信息
                if (org.springframework.util.StringUtils.isEmpty(formEntity.getKaOrderNumber())) {
                    BeanUtils.copyProperties(importVo, formEntity);
                    formEntity.setOrderNumber(CodeUtil.createOneCode(CrmCodeRuleConstants.KMS_ACCEP_FORM_NUMBER));
                    formEntity.setId(formEntity.getOrderNumber());
                    formEntity.setRawDataId(authEntity.getRespDataId());
                    formEntity.setKaCode(null);
                    formEntity.setInvoicesSource(KmsAdminEnum.AutoType.IMPORT.getDescription());
                    formEntity.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
                    detailDwEntities.add(formEntity);
                }
                //商品行信息
                KmsAcceptanceGoodsDetailDwEntity goodsDetailDwEntity = CrmBeanUtil.copy(importVo, KmsAcceptanceGoodsDetailDwEntity.class);
                goodsDetailDwEntity.setOrderNumber(formEntity.getOrderNumber());
                goodsDetailDwEntity.setItemIndex(i);
                goodsDetailDwEntity.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
                goodsDetailDwEntity.setId(null);
                goodsDetailDwEntity.setRawDataId(authEntity.getRespDataId());
                goodsDetailDwEntities.add(goodsDetailDwEntity);
            }
        });

        Map<String, KmsDataAuthEntity> authEntityMap = authEntities.stream()
                .collect(Collectors.toMap(KmsDataAuthEntity::getRespDataId, Function.identity()));

        authEntities.forEach(o -> {
            kmsDataAuthMapper.insert(o);
        });

        detailDwEntities.forEach(o -> {
            kmsAcceptanceFormDetailDwMapper.insert(o);
            //新增转换后的数据
            KmsAcceptanceFormEntity formEntity = CrmBeanUtil.copy(o, KmsAcceptanceFormEntity.class);
            formEntity.setOrderStatus(KmsEnum.OrderStatus.S101.getValue());
            formEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S101.getDescription());
            formEntity.setBsDirectSystemId(authEntityMap.get(o.getRawDataId()).getBsDirectSystemId());
            kmsAcceptanceFormMapper.insert(formEntity);
        });

        goodsDetailDwEntities.forEach(o -> {
            kmsAcceptanceGoodsDetailDwMapper.insert(o);
            KmsAcceptanceGoodsEntity goodsEntity = CrmBeanUtil.copy(o, KmsAcceptanceGoodsEntity.class);
            kmsAcceptanceGoodsMapper.insert(goodsEntity);
        });
    }
}

