package com.biz.crm.excel.component.saver.kms.confadmin;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.confadmin.KmsDirectStoreImportVo;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/5/28.
 */
@Slf4j
@Component("kmsDirectStoreImportSave")
@Transactional("kmsTransactionManager")
public class KmsDirectStoreImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsDirectStoreMapper, KmsDirectStoreEntity, KmsDirectStoreImportVo> implements ExcelImportSaver<KmsDirectStoreImportVo> {

    @Override
    public void save(List<KmsDirectStoreImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);
        List<List<KmsDirectStoreImportVo>> dateList = Lists.partition(data, 50);
        List<KmsDirectStoreImportVo> list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); i++) {
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    list.add(v.get(i));
                }
            }
        });
        this.saveBatch(CrmBeanUtil.copyList(list, KmsDirectStoreEntity.class));
    }
}

