package com.biz.crm.excel.component.saver.kms.kaproduct;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.kaproduct.KmsTenantryDirectProductImportVo;
import com.biz.crm.kaproduct.model.KmsProductUnitEntity;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductUnitMapper;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/25.
 */
@Slf4j
@Component("kmsTenantryDirectProductImportSave")
@Transactional(value = "kmsTransactionManager", rollbackFor = Exception.class)
public class KmsTenantryDirectProductImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsTenantryDirectProductMapper, KmsTenantryDirectProductEntity, KmsTenantryDirectProductImportVo> implements ExcelImportSaver<KmsTenantryDirectProductImportVo> {

    @Resource
    private KmsTenantryDirectProductUnitMapper unitMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void save(List<KmsTenantryDirectProductImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);
        Map<String, KmsTenantryDirectProductImportVo> dataMap = Maps.newHashMap();
        List<List<KmsTenantryDirectProductImportVo>> dateList = Lists.partition(data, 50);
        List<KmsTenantryDirectProductImportVo> list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); i++) {
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    list.add(v.get(i));
                }
            }
        });
        //头信息分组
        Map<String, List<KmsTenantryDirectProductImportVo>> productMap = list.stream()
                .collect(Collectors.groupingBy(o -> o.getBsDirectSystemCode() + "-" + o.getSellPartyCode() + "-" + o.getProductCode()));

        //循环每个map
        productMap.forEach((k, v) -> {
            //保存一个头信息
            if (CollectionUtil.listNotEmptyNotSizeZero(v)) {
                List<KmsProductUnitEntity> productUnitEntities = Lists.newArrayList();
                KmsTenantryDirectProductEntity copyEntity = CrmBeanUtil.copy(v.get(0), KmsTenantryDirectProductEntity.class);
                this.save(copyEntity);
                v.forEach(item -> {
                    KmsProductUnitEntity entity = new KmsProductUnitEntity();
                    entity.setTenantryDirectProductId(copyEntity.getId());
                    entity.setUnitCode(item.getUnitCode());
                    entity.setUnitName(item.getUnitName());
                    entity.setOrderType(item.getOrderType());
                    entity.setKaUnitCode(item.getKaUnitCode());
                    entity.setRatio(item.getRatio());
                    entity.setId(UUIDGenerator.generate());
                    entity.setNumerator(item.getNumerator());
                    UserRedis userRedis = UserUtils.getUser();
                    entity.setCreateCode(userRedis.getUsername());
                    entity.setCreateDate(DateUtil.formatDate());
                    entity.setCreateDateSecond(DateUtil.formatShortTime());
                    entity.setCreateDateAll(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
                    entity.setCreateOrgCode(userRedis.getOrgcode());
                    entity.setCreateOrgName(userRedis.getOrgname());
                    entity.setCreatePosCode(userRedis.getPoscode());
                    entity.setCreatePosName(userRedis.getPosname());
                    entity.setCreateName(userRedis.getRealname());
                    entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    productUnitEntities.add(entity);
                });
                if (CollectionUtils.isNotEmpty(productUnitEntities)) {
                    unitMapper.insertBatch(productUnitEntities);
                }
            }
        });
    }

}
