package com.biz.crm.excel.component.saver.kms.order;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.orderform.KmsOrderFormImportVo;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsDataAuthMapper;
import com.biz.crm.kms.form.orderform.mapper.KmsOrderFormDetailDwMapper;
import com.biz.crm.kms.form.orderform.mapper.KmsOrderFormMapper;
import com.biz.crm.kms.form.orderform.mapper.KmsOrderGoodsDetailDwMapper;
import com.biz.crm.kms.form.orderform.mapper.KmsOrderGoodsMapper;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.rawdata.model.KmsOrderFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsOrderGoodsDetailDwEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/8/26.
 */
@Slf4j
@Component("kmsOrderFormImportSave")
@Transactional("kmsTransactionManager")
public class KmsOrderFormImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsOrderFormDetailDwMapper, KmsOrderFormDetailDwEntity, KmsOrderFormImportVo> implements ExcelImportSaver<KmsOrderFormImportVo> {

    @Resource
    private KmsOrderFormDetailDwMapper kmsOrderFormDetailDwMapper;

    @Resource
    private KmsOrderGoodsDetailDwMapper kmsOrderGoodsDetailDwMapper;

    @Resource
    private KmsOrderFormMapper kmsOrderFormMapper;

    @Resource
    private KmsOrderGoodsMapper kmsOrderGoodsMapper;

    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    @Override
    public void save(List<KmsOrderFormImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);
        Map<String, List<KmsOrderFormImportVo>> dataMap = data.stream()
                .collect(Collectors.groupingBy(o -> o.getKaOrderNumber() + "#" + o.getVersionNumber()));
        List<KmsDataAuthEntity> authEntities = Lists.newArrayList();
        List<KmsOrderFormDetailDwEntity> detailDwEntities = Lists.newArrayList();
        List<KmsOrderGoodsDetailDwEntity> goodsDetailDwEntities = Lists.newArrayList();
        dataMap.forEach((k, v) -> {
            // 权限
            KmsDataAuthEntity authEntity = new KmsDataAuthEntity();
            KmsOrderFormDetailDwEntity formEntity = new KmsOrderFormDetailDwEntity();
            for (int i = 0; i < v.size(); i++) {
                KmsOrderFormImportVo importVo = v.get(i);
                //权限
                if (StringUtils.isEmpty(authEntity.getRespDataId())) {
                    authEntity.setRespDataId(UUIDGenerator.generate());
                    authEntity.setBsDirectSystemId(importVo.getBsDirectSystemId());
                    authEntities.add(authEntity);
                }
                //头信息
                if (org.springframework.util.StringUtils.isEmpty(formEntity.getKaOrderNumber())) {
                    BeanUtils.copyProperties(importVo, formEntity);
                    formEntity.setOrderNumber(CodeUtil.createOneCode(CrmCodeRuleConstants.KMS_ORDER_FORM_NUMBER));
                    formEntity.setId(formEntity.getOrderNumber());
                    formEntity.setRawDataId(authEntity.getRespDataId());
                    formEntity.setKaCode(null);
                    formEntity.setInvoicesSource(KmsAdminEnum.AutoType.IMPORT.getDescription());
                    formEntity.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
                    formEntity.setVersionNumber(Integer.parseInt(importVo.getVersionNumber()));
                    detailDwEntities.add(formEntity);
                }
                //商品行信息
                KmsOrderGoodsDetailDwEntity goodsDetailDwEntity = CrmBeanUtil.copy(importVo, KmsOrderGoodsDetailDwEntity.class);
                goodsDetailDwEntity.setOrderNumber(formEntity.getOrderNumber());
                goodsDetailDwEntity.setItemIndex(i);
                goodsDetailDwEntity.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
                goodsDetailDwEntity.setId(null);
                goodsDetailDwEntity.setRawDataId(authEntity.getRespDataId());
                goodsDetailDwEntity.setVersionNumber(Integer.parseInt(importVo.getVersionNumber()));
                goodsDetailDwEntities.add(goodsDetailDwEntity);
            }
        });

        Map<String, KmsDataAuthEntity> authEntityMap = authEntities.stream()
                .collect(Collectors.toMap(KmsDataAuthEntity::getRespDataId, Function.identity()));

        authEntities.forEach(o -> {
            kmsDataAuthMapper.insert(o);
        });

        detailDwEntities.forEach(o -> {
            kmsOrderFormDetailDwMapper.insert(o);
            //新增转换后的数据
            KmsOrderFormEntity formEntity = CrmBeanUtil.copy(o, KmsOrderFormEntity.class);
            formEntity.setOrderStatus(KmsEnum.OrderStatus.S101.getValue());
            formEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S101.getDescription());
            formEntity.setBsDirectSystemId(authEntityMap.get(o.getRawDataId()).getBsDirectSystemId());
            kmsOrderFormMapper.insert(formEntity);
        });

        goodsDetailDwEntities.forEach(o -> {
            kmsOrderGoodsDetailDwMapper.insert(o);
            KmsOrderGoodsEntity goodsEntity = CrmBeanUtil.copy(o, KmsOrderGoodsEntity.class);
            kmsOrderGoodsMapper.insert(goodsEntity);
        });
    }
}
