package com.biz.crm.excel.component.saver.kms.returnform;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.returnform.KmsReturnFormImportVo;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.kms.form.acceptanceform.mapper.KmsDataAuthMapper;
import com.biz.crm.kms.form.returnform.mapper.KmsReturnFormDetailDwMapper;
import com.biz.crm.kms.form.returnform.mapper.KmsReturnFormMapper;
import com.biz.crm.kms.form.returnform.mapper.KmsReturnGoodsDetailDwMapper;
import com.biz.crm.kms.form.returnform.mapper.KmsReturnGoodsMapper;
import com.biz.crm.rawdata.model.KmsReturnFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsReturnGoodsDetailDwEntity;
import com.biz.crm.returnform.model.KmsReturnFormEntity;
import com.biz.crm.returnform.model.KmsReturnGoodsEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/8/26.
 */
@Slf4j
@Component("kmsReturnFormImportSave")
@Transactional("kmsTransactionManager")
public class KmsReturnFormImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsReturnFormDetailDwMapper, KmsReturnFormDetailDwEntity, KmsReturnFormImportVo> implements ExcelImportSaver<KmsReturnFormImportVo> {

    @Resource
    private KmsReturnGoodsDetailDwMapper kmsReturnGoodsDetailDwMapper;

    @Resource
    private KmsReturnFormDetailDwMapper kmsReturnFormDetailDwMapper;

    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    @Resource
    private KmsReturnFormMapper kmsReturnFormMapper;

    @Resource
    private KmsReturnGoodsMapper kmsReturnGoodsMapper;


    @Override
    public void save(List<KmsReturnFormImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);
        Map<String, List<KmsReturnFormImportVo>> dataMap = data.stream()
                .collect(Collectors.groupingBy(o -> o.getKaOrderNumber()));
        List<KmsDataAuthEntity> authEntities = Lists.newArrayList();
        List<KmsReturnFormDetailDwEntity> detailDwEntities = Lists.newArrayList();
        List<KmsReturnGoodsDetailDwEntity> goodsDetailDwEntities = Lists.newArrayList();
        dataMap.forEach((k, v) -> {
            // 权限
            KmsDataAuthEntity authEntity = new KmsDataAuthEntity();
            KmsReturnFormDetailDwEntity formEntity = new KmsReturnFormDetailDwEntity();
            for (int i = 0; i < v.size(); i++) {
                KmsReturnFormImportVo importVo = v.get(i);
                //权限
                if (StringUtils.isEmpty(authEntity.getRespDataId())) {
                    authEntity.setRespDataId(UUIDGenerator.generate());
                    authEntity.setBsDirectSystemId(importVo.getBsDirectSystemId());
                    authEntities.add(authEntity);
                }
                //头信息
                if (org.springframework.util.StringUtils.isEmpty(formEntity.getKaOrderNumber())) {
                    BeanUtils.copyProperties(importVo, formEntity);
                    formEntity.setOrderNumber(CodeUtil.createOneCode(CrmCodeRuleConstants.KMS_ORDER_FORM_NUMBER));
                    formEntity.setId(formEntity.getOrderNumber());
                    formEntity.setRawDataId(authEntity.getRespDataId());
                    formEntity.setKaCode(null);
                    formEntity.setInvoicesSource(KmsAdminEnum.AutoType.IMPORT.getDescription());
                    formEntity.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
                    formEntity.setVersionNumber(Integer.parseInt(importVo.getVersionNumber()));
                    detailDwEntities.add(formEntity);
                }
                //商品行信息
                KmsReturnGoodsDetailDwEntity goodsDetailDwEntity = CrmBeanUtil.copy(importVo, KmsReturnGoodsDetailDwEntity.class);
                goodsDetailDwEntity.setOrderNumber(formEntity.getOrderNumber());
                goodsDetailDwEntity.setItemIndex(i);
                goodsDetailDwEntity.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
                goodsDetailDwEntity.setId(null);
                goodsDetailDwEntity.setRawDataId(authEntity.getRespDataId());
                goodsDetailDwEntity.setVersionNumber(Integer.parseInt(importVo.getVersionNumber()));
                goodsDetailDwEntities.add(goodsDetailDwEntity);
            }
        });

        Map<String, KmsDataAuthEntity> authEntityMap = authEntities.stream()
                .collect(Collectors.toMap(KmsDataAuthEntity::getRespDataId, Function.identity()));

        authEntities.forEach(o -> {
            kmsDataAuthMapper.insert(o);
        });

        detailDwEntities.forEach(o -> {
            kmsReturnFormDetailDwMapper.insert(o);
            //新增转换后的数据
            KmsReturnFormEntity formEntity = CrmBeanUtil.copy(o, KmsReturnFormEntity.class);
            formEntity.setOrderStatus(KmsEnum.OrderStatus.S101.getValue());
            formEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S101.getDescription());
            formEntity.setBsDirectSystemId(authEntityMap.get(o.getRawDataId()).getBsDirectSystemId());
            kmsReturnFormMapper.insert(formEntity);
        });

        goodsDetailDwEntities.forEach(o -> {
            kmsReturnGoodsDetailDwMapper.insert(o);
            KmsReturnGoodsEntity goodsEntity = CrmBeanUtil.copy(o, KmsReturnGoodsEntity.class);
            kmsReturnGoodsMapper.insert(goodsEntity);
        });
    }
}
