package com.biz.crm.excel.component.saver.kms.tenantrydirectaccount;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectaccount.KmsTenantryDirectAccountImportVo;
import com.biz.crm.kms.tenantrydirectaccount.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/5/25.
 */
@Slf4j
@Component("kmsTenantryDirectAccountImportSave")
@Transactional("kmsTransactionManager")
public class KmsTenantryDirectAccountImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsTenantryDirectAccountMapper, KmsTenantryDirectAccountEntity, KmsTenantryDirectAccountImportVo> implements ExcelImportSaver<KmsTenantryDirectAccountImportVo> {

    @Override
    public void save(List<KmsTenantryDirectAccountImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);

        List<List<KmsTenantryDirectAccountImportVo>> dateList = Lists.partition(data, 50);
        List<KmsTenantryDirectAccountImportVo> list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); i++) {
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    list.add(v.get(i));
                }
            }
        });
        this.saveBatch(CrmBeanUtil.copyList(list, KmsTenantryDirectAccountEntity.class));
    }
}
