package com.biz.crm.excel.component.saver.kms.tenantrydirectcustomerorg;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectcustomerorg.KmsTenantryDirectCustomerOrgImportVo;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/5/25.
 */
@Slf4j
@Component("kmsTenantryDirectCustomerOrgImportSave")
@Transactional("kmsTransactionManager")
public class KmsTenantryDirectCustomerOrgImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsTenantryDirectCustomerOrgMapper, KmsTenantryDirectCustomerOrgEntity, KmsTenantryDirectCustomerOrgImportVo> implements ExcelImportSaver<KmsTenantryDirectCustomerOrgImportVo> {

    @Override
    public void save(List<KmsTenantryDirectCustomerOrgImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);

        List<List<KmsTenantryDirectCustomerOrgImportVo>> dateList = Lists.partition(data, 50);
        List<KmsTenantryDirectCustomerOrgImportVo> list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); i++) {
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    list.add(v.get(i));
                }
            }
        });
        this.saveBatch(CrmBeanUtil.copyList(list, KmsTenantryDirectCustomerOrgEntity.class));
    }
}
