package com.biz.crm.excel.component.saver.kms.tenantrydirectstore;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectstore.KmsTenantryDirectStoreImportVo;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/4/27.
 */
@Slf4j
@Component("kmsTenantryDirectStoreImportSave")
@Transactional("kmsTransactionManager")
public class KmsTenantryDirectStoreImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsTenantryDirectStoreMapper, KmsTenantryDirectStoreEntity, KmsTenantryDirectStoreImportVo> implements ExcelImportSaver<KmsTenantryDirectStoreImportVo> {
    @Override
    public void save(List<KmsTenantryDirectStoreImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);

        List<List<KmsTenantryDirectStoreImportVo>> dateList = Lists.partition(data, 50);
        List<KmsTenantryDirectStoreImportVo> list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); i++) {
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    list.add(v.get(i));
                }
            }
        });
        this.saveBatch(CrmBeanUtil.copyList(list, KmsTenantryDirectStoreEntity.class));
    }
}
