package com.biz.crm.excel.component.saver.kms.totalwarehouse;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.totalwarehouse.KmsTotalWareHouseStoreImportVo;
import com.biz.crm.kms.totalwarehouse.mapper.KmsTotalWarehouseStoreMapper;
import com.biz.crm.supermarket.model.KmsTotalWarehouseStoreEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/4/27.
 */
@Slf4j
@Component("kmsTotalWarehouseStoreImportSave")
@Transactional("kmsTransactionManager")
public class KmsTotalWarehouseStoreImportSave<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<KmsTotalWarehouseStoreMapper, KmsTotalWarehouseStoreEntity, KmsTotalWareHouseStoreImportVo> implements ExcelImportSaver<KmsTotalWareHouseStoreImportVo> {

    @Override
    public void save(List<KmsTotalWareHouseStoreImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}", data);

        List<List<KmsTotalWareHouseStoreImportVo>> dateList = Lists.partition(data, 50);
        List<KmsTotalWareHouseStoreImportVo> list = Lists.newArrayList();
        dateList.forEach(v -> {
            for (int i = 0; i < v.size(); i++) {
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS) {
                    list.add(v.get(i));
                }
            }
        });
        this.saveBatch(CrmBeanUtil.copyList(list, KmsTotalWarehouseStoreEntity.class));
    }
}
