package com.biz.crm.excel.component.saver.mall;

import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mall.MallDeliveryImportVo;
import com.biz.crm.mall.MallDeliveryFeign;
import com.biz.crm.mall.dto.DeliveringDto;
import com.biz.crm.util.Result;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zwk
 * @date 2021/9/17
 * @description TODO
 **/
@Component("mallDeliverySaver")
public class MallDeliveryImportSaver implements ExcelImportSaver<MallDeliveryImportVo> {

    private final MallDeliveryFeign feign;

    public MallDeliveryImportSaver(MallDeliveryFeign feign) {
        this.feign = feign;
    }

    @Override
    public void save(List<MallDeliveryImportVo> data, DefaultImportContext context) {
    data.forEach(
        vo -> {
          DeliveringDto dto = new DeliveringDto();
          dto.setOrderCode(vo.getOrderCode());
          dto.setCompanyName(vo.getCompanyName());
          dto.setDeliveryCode(vo.getDeliveryCode());
          Result<?> result = this.feign.deliver(dto);
          if (result.isSuccess()) {
            vo.appendSuccessSaveMsg(result.getMessage());
          } else {
            vo.appendErrorSaveMsg(result.getMessage());
          }
        });
    }
}
