package com.biz.crm.excel.component.saver.mdm.availablelistrule;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.availablelistrule.AvailableRuleImportVo;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @Author: chenrong
 * @Date: 2021/3/18 10:26
 */
@Component("availableRuleSaver")
public class AvailableRuleSaver implements ExcelImportSaver<AvailableRuleImportVo> {

  //发送mq最大发送条数
  private static final int SEND_MAX_COUNT = 10;

  @Resource
  private RocketMQProducer rocketMQProducer;

  @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
  private String topic;

  /**
   * 保存数据逻辑
   * 在一个事务内完成，要么都成功，要么都失败
   * @param data
   * @param context
   */
  @Override
  public void save(List<AvailableRuleImportVo> data, DefaultImportContext context) {
    List<AvailableListRuleVo> ruleVos = this.buildRules(data);
    List<AvailableListRuleVo> sendList = Lists.newArrayList();
    for (int i = 0; i < ruleVos.size(); i++) {
      sendList.add(ruleVos.get(i));
      if ((i + 1) % SEND_MAX_COUNT == 0 || (i + 1) == ruleVos.size()) {
        //发送mq
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(topic);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(sendList));
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.AVAILABLE_RULE_IMPORT_TAG);
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
        sendList.clear();
      }
    }

  }

  /**
   * 构建可购规则列表
   * @param data
   * @return
   */
  private List<AvailableListRuleVo> buildRules(List<AvailableRuleImportVo> data) {
    List<AvailableListRuleVo> result = Lists.newArrayList();
    Map<String, List<AvailableRuleImportVo>> map = data.stream().collect(Collectors.groupingBy(AvailableRuleImportVo::getCode));
    map.values().forEach(list -> this.buildRules(list, result));
    return result;
  }

  /**
   * 构建单条可购规则
   * @param list
   * @param result
   */
  private void buildRules(List<AvailableRuleImportVo> list, List<AvailableListRuleVo> result) {
    if (CollectionUtil.listEmpty(list)) {
      return;
    }
    AvailableRuleImportVo importVoOne = list.get(0);
    List<AvailableListRuleAreaVo> areas = Lists.newArrayList();
    List<AvailableListRuleGoodsVo> goods = Lists.newArrayList();
    AvailableListRuleVo rule = CrmBeanUtil.copy(importVoOne, AvailableListRuleVo.class);
    //默认可购
    rule.setType(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
    list.forEach(li -> {
      AvailableListRuleAreaVo area = CrmBeanUtil.copy(li, AvailableListRuleAreaVo.class);
      AvailableListRuleGoodsVo good = CrmBeanUtil.copy(li, AvailableListRuleGoodsVo.class);
      areas.add(area);
      goods.add(good);
    });
    rule.setGoods(goods);
    rule.setAreaes(areas);
    result.add(rule);
  }
}
