package com.biz.crm.excel.component.saver.mdm.bpmrole;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.bpmrole.MdmBpmRoleImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component("mdmBpmRoleImportSaver")
@Transactional("mdmTransactionManager")
public class MdmBpmRoleImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmBpmRoleMapper, MdmBpmRoleEntity, MdmBpmRoleImportVo> implements ExcelImportSaver<MdmBpmRoleImportVo> {

    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public void save(List<MdmBpmRoleImportVo> data, DefaultImportContext context) {
        log.info("流程角色导入:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            List<MdmBpmRoleEntity> entityList = new ArrayList<>();
            for (MdmBpmRoleImportVo item :
                    data) {
                if (MdmBpmRoleImportVo.ProcessTypeEnum.SUCCESS == item.getProcessType()) {
                    MdmBpmRoleEntity copy = CrmBeanUtil.copy(item, MdmBpmRoleEntity.class);
                    if (StringUtils.isEmpty(copy.getBpmRoleCode())) {
                        copy.setBpmRoleCode(CodeUtil.generateCode(CodeRuleEnum.MDM_BPM_ROLE_CODE.getCode()));
                    }
                    copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    entityList.add(copy);
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List<List<MdmBpmRoleEntity>> partition = Lists.partition(entityList, 50);
                for (List<MdmBpmRoleEntity> item :
                        partition) {
                    this.saveBatch(item);
                    this.sendBpmRoleAdd(CrmBeanUtil.copyList(item, MdmBpmRoleRespVo.class));
                }
            }
        }
    }

    protected void sendBpmRoleAdd(List<MdmBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("职位新增发送MQ消息：{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.BPM_ROLE_ADD_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("职位新增发送MQ消息成功：{}", list);
    }

}
