package com.biz.crm.excel.component.saver.mdm.customer;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customer.MdmCustomerImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerContactMapper;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.mapper.MdmCustomerROrgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * 终端导入
 *
 * @author zxw
 * @date 2020-12-29 11:36
 **/
@Slf4j
@Component("mdmCustomerImportSaver")
@Transactional("mdmTransactionManager")
public class MdmCustomerImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmCustomerMsgMapper, MdmCustomerEntity, MdmCustomerImportVo> implements ExcelImportSaver<MdmCustomerImportVo> {

    @Resource
    private MdmCustomerContactMapper mdmCustomerContactMapper;
    @Resource
    private MdmCustomerROrgMapper mdmCustomerROrgMapper;

    @Override
    @Transactional(rollbackFor = Exception.class, transactionManager = "mdmTransactionManager")
    public void save(List<MdmCustomerImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            data.forEach(item -> {
                if (StringUtils.isEmpty(item.getCustomerCode())) {
                    item.setCustomerCode(CodeUtil.generateCode(CodeRuleEnum.MDM_CUSTOMER.getCode()));
                }
            });
            saveContact(data);
            saveOrg(data);
            List<List<MdmCustomerImportVo>> partition = Lists.partition(data, 50);
            for (List<MdmCustomerImportVo> mdmCustomerImportVos : partition) {
                List<MdmCustomerEntity> entityList = CrmBeanUtil.copyList(mdmCustomerImportVos, MdmCustomerEntity.class);
                for (MdmCustomerEntity mdmCustomerEntity : entityList) {
                    mdmCustomerEntity.setCustomerPrimary(YesNoEnum.yesNoEnum.ONE.getValue());
                    mdmCustomerEntity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
                    mdmCustomerEntity.setApprovalType(ApprovalType.NULL.getValue());
                    mdmCustomerEntity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                    mdmCustomerEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                }
                this.saveBatch(entityList);
            }
        }
    }


    /**
     * 保存客户联系人
     *
     * @param data list
     */
    protected void saveContact(List<MdmCustomerImportVo> data) {
        List<MdmCustomerContactEntity> mdmCustomerContactEntities = data.stream()
                .filter(x -> !StringUtils.isEmpty(x.getContactName()) || !StringUtils.isEmpty(x.getContactPhone()))
                .map(x -> {
                    MdmCustomerContactEntity mdmCustomerContactEntity = new MdmCustomerContactEntity();
                    mdmCustomerContactEntity.setId(UUID.randomUUID().toString());
                    mdmCustomerContactEntity.setCustomerCode(x.getCustomerCode());
                    mdmCustomerContactEntity.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                    mdmCustomerContactEntity.setContactName(x.getContactName());
                    mdmCustomerContactEntity.setContactPhone(x.getContactPhone());
                    return mdmCustomerContactEntity;
                })
                .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mdmCustomerContactEntities)) {
            mdmCustomerContactMapper.insertBatch(mdmCustomerContactEntities);
        }
    }

    protected void saveOrg(List<MdmCustomerImportVo> data) {
        List<MdmCustomerROrgEntity> mdmCustomerROrgEntityList = data.stream()
                .filter(x -> !StringUtils.isEmpty(x.getOrgCode()))
                .flatMap(x -> {
                    return Arrays.stream(x.getOrgCode().split(",")).map(y -> {
                        MdmCustomerROrgEntity entity = new MdmCustomerROrgEntity();
                        entity.setCustomerCode(x.getCustomerCode());
                        entity.setOrgCode(y);
                        return entity;
                    });
                }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mdmCustomerROrgEntityList)) {
            mdmCustomerROrgEntityList.forEach(x -> mdmCustomerROrgMapper.insert(x));
        }
    }

}
