package com.biz.crm.excel.component.saver.mdm.customermaterial;

import com.alibaba.excel.context.AnalysisContext;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.mdm.customermaterial.MdmCustomerMaterialImportVo;
import com.biz.crm.excel.vo.mdm.positionlevel.MdmPositionLevelImportVo;
import com.biz.crm.mdm.customermaterial.entity.MdmCustomerMaterialEntity;
import com.biz.crm.mdm.customermaterial.mapper.MdmCustomerMaterialMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.sfa.test.entity.TestImportEntity;
import com.biz.crm.sfa.test.mapper.TestImportMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 客户物料数据保存
 * @project：crm-core
 * @package：com.biz.crm.excel.component.saver.mdm.customermaterial
 * @author：longyu
 * @create：2021/1/4 13:47
 */
@Slf4j
@Component("mdmCustomerMaterialImportSave")
@Transactional("mdmTransactionManager")
public class MdmCustomerMaterialImportSave <M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmCustomerMaterialMapper, MdmCustomerMaterialEntity, MdmCustomerMaterialImportVo> implements ExcelImportSaver<MdmCustomerMaterialImportVo> {


    @Override
    public void save(List<MdmCustomerMaterialImportVo> data, DefaultImportContext context) {
        log.info("数据保存:{}",data);

        List<List<MdmCustomerMaterialImportVo>> DataList = Lists.partition(data, 50);
        List<MdmCustomerMaterialImportVo> list = new ArrayList<>();
        DataList.forEach( v -> {
            for (int i = 0;i<v.size();i++){
                if (v.get(i).getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS){
                    list.add(v.get(i));
                }
            }
        });
        this.saveBatch(CrmBeanUtil.copyList(list,MdmCustomerMaterialEntity.class));
    }
}
