package com.biz.crm.excel.component.saver.mdm.customerorg;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customerorg.MdmCustomerOrgImportVo;
import com.biz.crm.excel.vo.mdm.org.MdmOrgImportVo;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@Slf4j
@Component("mdmCustomerOrgImportSaver")
@Transactional("mdmTransactionManager")
public class MdmCustomerOrgImportSaver<M extends BaseMapper<T>, T> extends AbstractExcelImportSaver<MdmCusOrgMapper, MdmCusOrgEntity, MdmCustomerOrgImportVo> implements ExcelImportSaver<MdmCustomerOrgImportVo> {

    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Override
    public void save(List<MdmCustomerOrgImportVo> data, DefaultImportContext context) {
        log.info("组织导入:{}", data);
        if (!CollectionUtils.isEmpty(data)) {

            List<MdmCustomerOrgImportVo> collect = data.stream().filter(x -> MdmOrgImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType()).collect(Collectors.toList());

            if (CollectionUtil.listNotEmptyNotSizeZero(collect)) {

                int size = collect.stream().filter(x -> StringUtils.isEmpty(x.getCustomerOrgCode())).collect(Collectors.toList()).size();
                if (size > 0) {
                    List<String> codeList = CodeUtil.generateCodeList(CodeRuleEnum.MDM_CUSTOMER_ORG.getCode(), size);
                    int i = 0;
                    for (MdmCustomerOrgImportVo item :
                            collect) {
                        if (StringUtils.isEmpty(item.getCustomerOrgCode())) {
                            item.setCustomerOrgCode(codeList.get(i++));
                        }
                    }
                }

                List<MdmCusOrgEntity> entityList = new ArrayList<>();
                for (MdmCustomerOrgImportVo item :
                        collect) {
                    MdmCusOrgEntity copy = CrmBeanUtil.copy(item, MdmCusOrgEntity.class);
                    copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                    copy.setLevelNum(1);
                    entityList.add(copy);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                    List<List<MdmCusOrgEntity>> partition = Lists.partition(entityList, 50);
                    for (List<MdmCusOrgEntity> item :
                            partition) {
                        this.saveBatch(item);
                    }
                    resetRuleCode();
                }
            }
        }
    }

    /**
     * 全表重置降维编码，方法需要优化
     */
    private void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------重置客户组织降维编码（导入）_" + l + "_开始-----------");
        mdmCusOrgMapper.copyIdToRuleCode();
        log.info("-----------重置客户组织降维编码（导入）_" + l + "_编码重置成id成功-----------");
        mdmCusOrgMapper.setNullNotExistParentCode();
        log.info("-----------重置客户组织降维编码（导入）_" + l + "_清除无效上级编码成功-----------");
        List<MdmCusOrgEntity> list = this.lambdaQuery()
                .isNull(MdmCusOrgEntity::getParentCode)
                .or()
                .eq(MdmCusOrgEntity::getParentCode, "")
                .list();
        for (int i = 0; i < list.size(); i++) {
            updateCurAndChildren(list.get(i).getCustomerOrgCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
        log.info("-----------重置客户组织降维编码（导入）_" + l + "_编码重新生成成功-----------");
        CustomerOrgUtil.deleteAllCache();
        log.info("-----------重置客户组织降维编码（导入）_" + l + "_缓存清除成功-----------");
        log.info("-----------重置客户组织降维编码（导入）_" + l + "_结束-----------");
    }

    /**
     * 更新组织及组织下级降维编码和层级
     *
     * @param orgCode  当前组织编码
     * @param curCode  当前组织降维编码
     * @param levelNum 当前层级
     */
    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {

        //更新当前
        this.lambdaUpdate()
                .eq(MdmCusOrgEntity::getCustomerOrgCode, orgCode)
                .set(MdmCusOrgEntity::getRuleCode, curCode)
                .set(MdmCusOrgEntity::getLevelNum, levelNum)
                .update();

        //查询下一层
        List<MdmCusOrgEntity> list = this.lambdaQuery()
                .eq(MdmCusOrgEntity::getParentCode, orgCode)
                .select(MdmCusOrgEntity::getCustomerOrgCode)
                .list();

        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            //遍历下级
            for (int i = 0; i < list.size(); i++) {
                //递归调用
                updateCurAndChildren(list.get(i).getCustomerOrgCode(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1), (levelNum + 1));
            }
        }
    }
}
