package com.biz.crm.excel.component.saver.mdm.function;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.constant.mdm.SqlConfigConstant;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.PermissionResourceEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.function.MdmDataPermissionImportVo;
import com.biz.crm.mdm.function.entity.MdmDataPermissionEntity;
import com.biz.crm.mdm.function.entity.MdmDataPermissionExtendEntity;
import com.biz.crm.mdm.function.mapper.MdmDataPermissionExtendMapper;
import com.biz.crm.mdm.function.mapper.MdmDataPermissionMapper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-04-14 10:33
 **/
@Slf4j
@Component("mdmDataPermissionImportSavor")
@Transactional(value = "mdmTransactionManager", rollbackFor = Exception.class)
public class MdmDataPermissionImportSavor implements ExcelImportSaver<MdmDataPermissionImportVo> {

    @Resource
    private MdmDataPermissionMapper mdmDataPermissionMapper;

    @Resource
    private MdmDataPermissionExtendMapper mdmDataPermissionExtendMapper;


    @Override
    public void save(List<MdmDataPermissionImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Set<String> functionSet = data.stream().map(MdmDataPermissionImportVo::getFunctionCode)
                .collect(Collectors.toSet());
        LambdaQueryWrapper<MdmDataPermissionEntity> dataPermissionWrapper = Wrappers.<MdmDataPermissionEntity>lambdaQuery()
                .in(MdmDataPermissionEntity::getFunctionCode, functionSet);
        List<String> dataPermissionUniqueKey = Optional.ofNullable(mdmDataPermissionMapper.selectList(dataPermissionWrapper))
                .map(x -> x.stream()
                        .map(k -> k.getFunctionCode() + k.getListConfigCode() + k.getRoleCode())
                        .distinct()
                        .collect(Collectors.toList()))
                .orElse(new ArrayList<>());

        LambdaQueryWrapper<MdmDataPermissionExtendEntity> extendDataPermissionWrapper = Wrappers.<MdmDataPermissionExtendEntity>lambdaQuery()
                .in(MdmDataPermissionExtendEntity::getFunctionCode, functionSet);
        List<String> extendPermissionUniqueKey = Optional.ofNullable(mdmDataPermissionExtendMapper.selectList(extendDataPermissionWrapper))
                .map(x -> x.stream().map(k -> k.getFunctionCode() + k.getListConfigCode() + k.getRoleCode()
                        + k.getPermissionObjCode() + k.getPermissionResource() + k.getPermissionSearchType())
                        .distinct()
                        .collect(Collectors.toList()))
                .orElse(new ArrayList<>());

        data = data.stream()
                .peek(x -> x.setPermissionResource(PermissionResourceEnum.PRESUPPOSITION.getCode()))
                .collect(Collectors.toList());
        String nowDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Lists.partition(data, SqlConfigConstant.IN_SIZE).parallelStream()
                .forEach(list -> {
                    List<MdmDataPermissionEntity> mdmDataPermissionEntities = list.stream()
                            .filter(x -> !dataPermissionUniqueKey.contains(x.getFunctionCode() + x.getListConfigCode() + x.getRoleCode()))
                            .map(x -> {
                                MdmDataPermissionEntity mdmDataPermissionEntity = new MdmDataPermissionEntity();
                                mdmDataPermissionEntity.setId(UUID.randomUUID().toString());
                                mdmDataPermissionEntity.setFunctionCode(x.getFunctionCode());
                                mdmDataPermissionEntity.setListConfigCode(x.getListConfigCode());
                                mdmDataPermissionEntity.setRoleCode(x.getRoleCode());
                                mdmDataPermissionEntity.setPermissionResource(x.getPermissionResource());
                                mdmDataPermissionEntity.setPermissionObjCode(x.getPermissionObjCode());
                                mdmDataPermissionEntity.setPermissionSearchType(x.getPermissionSearchType());
                                mdmDataPermissionEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                                mdmDataPermissionEntity.setCreateDate(nowDate);
                                return mdmDataPermissionEntity;
                            }).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(mdmDataPermissionEntities)) {
                        mdmDataPermissionMapper.insertBatch(mdmDataPermissionEntities);
                    }
                    List<MdmDataPermissionExtendEntity> extendEntityList = list.stream()
                            .filter(x -> !extendPermissionUniqueKey.contains(x.getFunctionCode() + x.getListConfigCode() + x.getRoleCode() + x.getPermissionObjCode()
                                    + x.getPermissionResource() + x.getPermissionSearchType()))
                            .map(x -> {
                                MdmDataPermissionExtendEntity mdmDataPermissionExtendEntity = new MdmDataPermissionExtendEntity();
                                mdmDataPermissionExtendEntity.setId(UUID.randomUUID().toString());
                                mdmDataPermissionExtendEntity.setRoleCode(x.getRoleCode());
                                mdmDataPermissionExtendEntity.setFunctionCode(x.getFunctionCode());
                                mdmDataPermissionExtendEntity.setListConfigCode(x.getListConfigCode());
                                mdmDataPermissionExtendEntity.setPermissionObjCode(x.getPermissionObjCode());
                                mdmDataPermissionExtendEntity.setPermissionResource(x.getPermissionResource());
                                mdmDataPermissionExtendEntity.setPermissionSearchType(x.getPermissionSearchType());
                                mdmDataPermissionExtendEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                                mdmDataPermissionExtendEntity.setCreateDate(nowDate);
                                return mdmDataPermissionExtendEntity;
                            }).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(extendEntityList)) {
                        mdmDataPermissionMapper.insertExtendBatch(extendEntityList);
                    }
                });
    }
}
