package com.biz.crm.excel.component.saver.mdm.function;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.constant.mdm.SqlConfigConstant;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.function.MdmRoleFunctionButtonImportVo;
import com.biz.crm.mdm.function.entity.MdmButtonRoleEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionRoleEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.function.mapper.MdmButtonRoleMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionRoleMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionSubButtonMapper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-04-14 10:33
 **/
@Slf4j
@Component("mdmRoleFunctionButtonImportSavor")
@Transactional(value = "mdmTransactionManager", rollbackFor = Exception.class)
public class MdmRoleFunctionButtonImportSavor implements ExcelImportSaver<MdmRoleFunctionButtonImportVo> {

    @Resource
    private MdmFunctionRoleMapper mdmFunctionRoleMapper;

    @Resource
    private MdmFunctionSubButtonMapper mdmFunctionSubButtonMapper;

    @Resource
    private MdmButtonRoleMapper mdmButtonRoleMapper;

    @Override
    public void save(List<MdmRoleFunctionButtonImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        saveFunctionRole(data);
        List<MdmButtonRoleEntity> list = new ArrayList<>();
        list.addAll(setUpAllConfigButtonList(data));
        list.addAll(setUpAllButtonList(data));
        list.addAll(setUpButtonList(data));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Collection<MdmButtonRoleEntity> values = list.stream()
                .collect(Collectors.toMap(x -> x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode(), Function.identity()))
                .values();
        list = new ArrayList<>(values);

        //查询已存在的按钮-角色关联
        Set<String> excelRoleCodeSet = new HashSet<>();
        Set<String> excelFunctionCodeSet = new HashSet<>();
        Set<String> excelConfigCodeSet = new HashSet<>();
        Set<String> excelButtonCodeSet = new HashSet<>();
        for (MdmButtonRoleEntity buttonRoleEntity : list) {
            excelRoleCodeSet.add(buttonRoleEntity.getRoleCode());
            excelFunctionCodeSet.add(buttonRoleEntity.getParentCode());
            excelConfigCodeSet.add(buttonRoleEntity.getFunctionCode());
            excelButtonCodeSet.add(buttonRoleEntity.getButtonCode());
        }
        if (!CollectionUtils.isEmpty(excelRoleCodeSet) && !CollectionUtils.isEmpty(excelFunctionCodeSet)
        &&!CollectionUtils.isEmpty(excelConfigCodeSet)&&!CollectionUtils.isEmpty(excelButtonCodeSet)) {
            LambdaQueryWrapper<MdmButtonRoleEntity> buttonRoleWrapper = Wrappers.<MdmButtonRoleEntity>lambdaQuery()
                    .in(MdmButtonRoleEntity::getRoleCode, excelRoleCodeSet)
                    .in(MdmButtonRoleEntity::getParentCode, excelFunctionCodeSet)
                    .in(MdmButtonRoleEntity::getFunctionCode, excelConfigCodeSet)
                    .in(MdmButtonRoleEntity::getButtonCode, excelButtonCodeSet);
            List<MdmButtonRoleEntity> mdmButtonRoleEntities = mdmButtonRoleMapper.selectList(buttonRoleWrapper);
            if (!CollectionUtils.isEmpty(mdmButtonRoleEntities)) {
                Set<String> repeatSet = mdmButtonRoleEntities.stream()
                        .map(x -> x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode())
                        .collect(Collectors.toSet());
                Collection<MdmButtonRoleEntity> values1 = list.stream()
                        .filter(x -> !repeatSet.contains(x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode()))
                        .collect(Collectors.toMap(x -> x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode(), Function.identity(),(x1,x2)->x1))
                        .values();
                list = new ArrayList<>(values1);
            }
        }
        list.forEach(x->x.setId(UUID.randomUUID().toString()));
        mdmButtonRoleMapper.insertBatch(list);
    }

    protected List<MdmButtonRoleEntity> setUpButtonList(List<MdmRoleFunctionButtonImportVo> data) {
        return data.stream()
                .filter(x -> !StringUtils.isEmpty(x.getListConfigCode()) && !StringUtils.isEmpty(x.getButtonCode()))
                .map(x->{
                    MdmButtonRoleEntity buttonRoleEntity = new MdmButtonRoleEntity();
                    buttonRoleEntity.setButtonCode(x.getButtonCode());
                    buttonRoleEntity.setRoleCode(x.getRoleCode());
                    buttonRoleEntity.setParentCode(x.getFunctionCode());
                    buttonRoleEntity.setFunctionCode(x.getListConfigCode());
                    return buttonRoleEntity;
                })
                .collect(Collectors.toList());
    }

    protected List<MdmButtonRoleEntity> setUpAllButtonList(List<MdmRoleFunctionButtonImportVo> data) {
        List<MdmRoleFunctionButtonImportVo> collect = data.stream()
                .filter(x -> !StringUtils.isEmpty(x.getListConfigCode()) && StringUtils.isEmpty(x.getButtonCode()))
                .filter(x -> {
                    //假如相同角色，相同菜单，相同功能列表，部分填了按钮，整体排除
                    for (MdmRoleFunctionButtonImportVo importVo : data) {
                        if (importVo.getRoleCode().equals(x.getRoleCode())
                                && importVo.getFunctionCode().equals(x.getFunctionCode())
                                && x.getListConfigCode().equals(importVo.getListConfigCode())
                                && !StringUtils.isEmpty(importVo.getButtonCode())) {
                            return false;
                        }
                    }
                    return true;
                })
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new ArrayList<>();
        }
        //查询菜单,功能列表关联的所有按钮
        Set<String> excelFunctionCodeSet = new HashSet<>();
        Set<String> excelConfigCodeSet = new HashSet<>();
        for (MdmRoleFunctionButtonImportVo importVo : collect) {
            excelFunctionCodeSet.add(importVo.getFunctionCode());
            excelConfigCodeSet.add(importVo.getListConfigCode());
        }
        LambdaQueryWrapper<MdmFunctionSubButtonEntity> functionButtonWrapper = Wrappers.<MdmFunctionSubButtonEntity>lambdaQuery()
                .in(MdmFunctionSubButtonEntity::getParentCode, excelFunctionCodeSet)
                .in(MdmFunctionSubButtonEntity::getFunctionCode, excelConfigCodeSet)
                .select(MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode);
        List<MdmFunctionSubButtonEntity> mdmFunctionSubButtonEntities = mdmFunctionSubButtonMapper.selectList(functionButtonWrapper);
        if (CollectionUtils.isEmpty(mdmFunctionSubButtonEntities)) {
            return new ArrayList<>();
        }
        Map<String, Set<String>> configMap = collect.stream()
                .collect(Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getListConfigCode
                        , Collectors.mapping(x -> x.getFunctionCode() + ":" + x.getListConfigCode(), Collectors.toSet())));
        return mdmFunctionSubButtonEntities.stream()
                .filter(x -> {
                    Set<String> roleCodeSet = configMap.get(x.getParentCode() + ":" + x.getFunctionCode());
                    return !CollectionUtils.isEmpty(roleCodeSet);
                })
                .flatMap(x -> {
                    Set<String> roleCodeSet = configMap.get(x.getParentCode() + ":" + x.getFunctionCode());
                    return roleCodeSet.stream().map(k -> {
                        MdmButtonRoleEntity mdmButtonRoleEntity = new MdmButtonRoleEntity();
                        mdmButtonRoleEntity.setRoleCode(k);
                        mdmButtonRoleEntity.setParentCode(x.getParentCode());
                        mdmButtonRoleEntity.setFunctionCode(x.getFunctionCode());
                        mdmButtonRoleEntity.setButtonCode(x.getButtonCode());
                        return mdmButtonRoleEntity;
                    });
                }).collect(Collectors.toList());
    }

    protected List<MdmButtonRoleEntity> setUpAllConfigButtonList(List<MdmRoleFunctionButtonImportVo> data) {
        List<MdmRoleFunctionButtonImportVo> collect = data.stream()
                .filter(x -> StringUtils.isEmpty(x.getListConfigCode()) && StringUtils.isEmpty(x.getButtonCode()))
                .filter(x -> {
                    //假如相同角色，相同菜单，部分填了功能列表，整体排除
                    for (MdmRoleFunctionButtonImportVo importVo : data) {
                        if (importVo.getRoleCode().equals(x.getRoleCode())
                                && importVo.getFunctionCode().equals(x.getFunctionCode())
                                && !StringUtils.isEmpty(importVo.getListConfigCode())) {
                            return false;
                        }
                    }
                    return true;
                })
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new ArrayList<>();
        }
        //查询菜单,功能列表关联的所有按钮
        Set<String> excelFunctionCodeSet = new HashSet<>();
        for (MdmRoleFunctionButtonImportVo importVo : collect) {
            excelFunctionCodeSet.add(importVo.getFunctionCode());
        }
        LambdaQueryWrapper<MdmFunctionSubButtonEntity> functionButtonWrapper = Wrappers.<MdmFunctionSubButtonEntity>lambdaQuery()
                .in(MdmFunctionSubButtonEntity::getParentCode, excelFunctionCodeSet)
                .select(MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode);
        List<MdmFunctionSubButtonEntity> mdmFunctionSubButtonEntities = mdmFunctionSubButtonMapper.selectList(functionButtonWrapper);
        if (CollectionUtils.isEmpty(mdmFunctionSubButtonEntities)) {
            return new ArrayList<>();
        }
        //构建角色-按钮数据
        Map<String, Set<String>> functionRoleMap = collect.stream().collect(Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getFunctionCode
                , Collectors.mapping(MdmRoleFunctionButtonImportVo::getRoleCode, Collectors.toSet())));
        return mdmFunctionSubButtonEntities.stream()
                .filter(x -> {
                    Set<String> roleCodeSet = functionRoleMap.get(x.getParentCode());
                    return !CollectionUtils.isEmpty(roleCodeSet);
                })
                .flatMap(x -> {
                    Set<String> roleCodeSet = functionRoleMap.get(x.getParentCode());
                    return roleCodeSet.stream().map(k -> {
                        MdmButtonRoleEntity mdmButtonRoleEntity = new MdmButtonRoleEntity();
                        mdmButtonRoleEntity.setRoleCode(k);
                        mdmButtonRoleEntity.setParentCode(x.getParentCode());
                        mdmButtonRoleEntity.setFunctionCode(x.getFunctionCode());
                        mdmButtonRoleEntity.setButtonCode(x.getButtonCode());
                        return mdmButtonRoleEntity;
                    });
                }).collect(Collectors.toList());
    }

    /**
     * 保存菜单与角色关联关系
     *
     * @param data list
     */
    protected void saveFunctionRole(List<MdmRoleFunctionButtonImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        //校验已经导入的关联信息
//        Set<String> mayDbRoleCodeSet = new HashSet<>();
        Set<String> mayDbFunctionCodeSet = new HashSet<>();
        data.stream()
                .filter(x -> !StringUtils.isEmpty(x.getRoleCode()) && !StringUtils.isEmpty(x.getFunctionCode()))
                .forEach(x -> {
//                    mayDbRoleCodeSet.add(x.getRoleCode());
                    mayDbFunctionCodeSet.add(x.getFunctionCode());
                });
        if (!CollectionUtils.isEmpty(mayDbFunctionCodeSet)) {
            LambdaQueryWrapper<MdmFunctionRoleEntity> wrapper = Wrappers.<MdmFunctionRoleEntity>lambdaQuery()
                    .in(MdmFunctionRoleEntity::getFunctionCode, mayDbFunctionCodeSet)
                    .select(MdmFunctionRoleEntity::getRoleCode, MdmFunctionRoleEntity::getFunctionCode);

            List<String> functionRoleUniqueKey = mdmFunctionRoleMapper.selectList(wrapper)
                    .stream()
                    .map(x -> x.getFunctionCode() + ":" + x.getRoleCode())
                    .distinct()
                    .collect(Collectors.toList());
            Collection<MdmRoleFunctionButtonImportVo> values = data.stream()
                    .filter(x -> !functionRoleUniqueKey.contains(x.getFunctionCode() + ":" + x.getRoleCode()))
                    .collect(Collectors.toMap(x -> x.getFunctionCode() + "" + x.getRoleCode(), Function.identity(), (x1, x2) -> x1))
                    .values();
            List<MdmRoleFunctionButtonImportVo> collect = new ArrayList<>(values);
            Lists.partition(collect, SqlConfigConstant.IN_SIZE).parallelStream()
                    .forEach(x -> {
                        List<MdmFunctionRoleEntity> mdmFunctionRoleEntityList = x.stream().map(k -> {
                            MdmFunctionRoleEntity mdmFunctionRoleEntity = new MdmFunctionRoleEntity();
                            mdmFunctionRoleEntity.setId(UUID.randomUUID().toString());
                            mdmFunctionRoleEntity.setRoleCode(k.getRoleCode());
                            mdmFunctionRoleEntity.setFunctionCode(k.getFunctionCode());
                            return mdmFunctionRoleEntity;
                        }).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(mdmFunctionRoleEntityList)) {
                            mdmFunctionRoleMapper.insertBatch(mdmFunctionRoleEntityList);
                        }
                    });
        }
    }

    public static void main(String[] args) {
        MdmRoleFunctionButtonImportVo m1 = new MdmRoleFunctionButtonImportVo();
        m1.setRoleCode("r1");
        m1.setFunctionCode("f1");
        m1.setListConfigCode("l1");
        MdmRoleFunctionButtonImportVo m2 = new MdmRoleFunctionButtonImportVo();
        m2.setRoleCode("r2");
        m2.setFunctionCode("f2");
        m2.setListConfigCode("l2");
        m2.setButtonCode("b2");
        MdmRoleFunctionButtonImportVo m3 = new MdmRoleFunctionButtonImportVo();
        m3.setRoleCode("r3");
        m3.setFunctionCode("f3");
        List<MdmRoleFunctionButtonImportVo> list = Arrays.asList(m1, m2, m3);
        Map<String, Map<String, List<MdmRoleFunctionButtonImportVo>>> collect = list.stream().collect(Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getRoleCode
                , Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getFunctionCode)));
        System.out.println(1);
    }
}
